/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.BasicCompletes;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class RepeatableCompletes<T>
extends BasicCompletes<T> {
    public RepeatableCompletes(Scheduler scheduler) {
        super(new RepeatableActiveState(scheduler));
    }

    public RepeatableCompletes(T outcome, boolean succeeded) {
        super(new RepeatableActiveState(), outcome, succeeded);
    }

    public RepeatableCompletes(T outcome) {
        super(new RepeatableActiveState(), outcome);
    }

    @Override
    public Completes<T> repeat() {
        if (this.state.isOutcomeKnown()) {
            this.state.repeat();
        }
        return this;
    }

    @Override
    public <O> Completes<O> with(O outcome) {
        super.with(outcome);
        this.state.repeat();
        return this;
    }

    protected static class RepeatableActiveState<T>
    extends BasicCompletes.BasicActiveState<T> {
        private final Queue<BasicCompletes.Action<T>> actionsBackup = new ConcurrentLinkedQueue<BasicCompletes.Action<T>>();
        private final AtomicBoolean repeating = new AtomicBoolean(false);

        protected RepeatableActiveState(Scheduler scheduler) {
            super(scheduler);
        }

        protected RepeatableActiveState() {
            this(null);
        }

        @Override
        public void backUp(BasicCompletes.Action<T> action) {
            if (action != null) {
                this.actionsBackup.add(action);
            }
        }

        @Override
        public void repeat() {
            if (this.repeating.compareAndSet(false, true)) {
                this.restore();
                this.outcomeKnown(false);
                this.repeating.set(false);
            }
        }

        @Override
        public void restore() {
            while (this.actionsBackup.peek() != null) {
                this.restore(this.actionsBackup.poll());
            }
        }
    }
}

