/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Scheduler {
    private final ScheduledExecutorService timer = Executors.newScheduledThreadPool(1);

    public <T> Cancellable schedule(Scheduled<T> scheduled, T data, long delayBefore, long interval) {
        SchedulerTask<T> schedulerTask = new SchedulerTask<T>(scheduled, data, true);
        ScheduledFuture<?> future = this.timer.scheduleWithFixedDelay(schedulerTask, delayBefore, interval, TimeUnit.MILLISECONDS);
        schedulerTask.setFuture(future);
        return schedulerTask;
    }

    public <T> Cancellable schedule(Scheduled<T> scheduled, T data, Duration delayBefore, Duration interval) {
        return this.schedule(scheduled, data, delayBefore.toMillis(), interval.toMillis());
    }

    public <T> Cancellable scheduleOnce(Scheduled<T> scheduled, T data, long delayBefore, long interval) {
        SchedulerTask<T> schedulerTask = new SchedulerTask<T>(scheduled, data, false);
        ScheduledFuture<?> future = this.timer.schedule(schedulerTask, delayBefore + interval, TimeUnit.MILLISECONDS);
        schedulerTask.setFuture(future);
        return schedulerTask;
    }

    public <T> Cancellable scheduleOnce(Scheduled<T> scheduled, T data, Duration delayBefore, Duration interval) {
        return this.scheduleOnce(scheduled, data, delayBefore.toMillis(), interval.toMillis());
    }

    public void close() {
        this.timer.shutdown();
    }

    private class SchedulerTask<T>
    implements Runnable,
    Cancellable {
        private boolean cancelled;
        private final Scheduled<T> scheduled;
        private final T data;
        private final boolean repeats;
        private ScheduledFuture<?> future;

        SchedulerTask(Scheduled<T> scheduled, T data, boolean repeats) {
            this.scheduled = scheduled;
            this.data = data;
            this.repeats = repeats;
            this.cancelled = false;
        }

        @Override
        public void run() {
            this.scheduled.intervalSignal(this.scheduled, this.data);
            if (!this.repeats) {
                this.cancel();
            }
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            if (this.future != null) {
                return this.future.cancel(false);
            }
            return this.cancelled;
        }

        void setFuture(ScheduledFuture<?> future) {
            this.future = future;
            if (this.cancelled) {
                this.cancel();
            }
        }
    }
}

