/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.Completes;
import io.vlingo.common.Failure;
import io.vlingo.common.Outcome;
import io.vlingo.common.Tuple2;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Success<CauseT extends Throwable, ValueT>
implements Outcome<CauseT, ValueT> {
    private final ValueT value;

    private Success(ValueT value) {
        this.value = value;
    }

    public static <CauseT extends Throwable, ValueT> Outcome<CauseT, ValueT> of(ValueT value) {
        return new Success<CauseT, ValueT>(value);
    }

    @Override
    public <NextSuccessT> Outcome<CauseT, NextSuccessT> andThen(Function<ValueT, NextSuccessT> action) {
        return Success.of(action.apply(this.value));
    }

    @Override
    public <NextCauseT extends Throwable, NextSuccessT> Outcome<NextCauseT, NextSuccessT> andThenTo(Function<ValueT, Outcome<NextCauseT, NextSuccessT>> action) {
        return action.apply(this.value);
    }

    @Override
    public void atLeastConsume(Consumer<ValueT> consumer) {
        consumer.accept(this.value);
    }

    @Override
    public Outcome<CauseT, ValueT> otherwise(Function<CauseT, ValueT> action) {
        return this;
    }

    @Override
    public <NextCauseT extends Throwable, NextSuccessT> Outcome<NextCauseT, NextSuccessT> otherwiseTo(Function<CauseT, Outcome<NextCauseT, NextSuccessT>> action) {
        return this;
    }

    @Override
    public ValueT get() throws CauseT {
        return this.value;
    }

    @Override
    public ValueT getOrNull() {
        return this.value;
    }

    @Override
    public <NextSuccessT> NextSuccessT resolve(Function<CauseT, NextSuccessT> onFailedOutcome, Function<ValueT, NextSuccessT> onSuccessfulOutcome) {
        return onSuccessfulOutcome.apply(this.value);
    }

    @Override
    public Optional<ValueT> asOptional() {
        return Optional.of(this.value);
    }

    @Override
    public Completes<ValueT> asCompletes() {
        return Completes.withSuccess(this.value);
    }

    @Override
    public Outcome<NoSuchElementException, ValueT> filter(Function<ValueT, Boolean> filterFunction) {
        if (filterFunction.apply(this.value).booleanValue()) {
            return Success.of(this.value);
        }
        return Failure.of(new NoSuchElementException(Objects.toString(this.value, "null")));
    }

    @Override
    public <SecondSuccessT> Outcome<CauseT, Tuple2<ValueT, SecondSuccessT>> alongWith(Outcome<?, SecondSuccessT> outcome) {
        return outcome.andThenTo((SuccessT secondOutcome) -> Success.of(Tuple2.from(this.value, secondOutcome)));
    }

    @Override
    public <NextFailureT extends Throwable> Outcome<NextFailureT, ValueT> otherwiseFail(Function<CauseT, NextFailureT> action) {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.value.equals(((Success)other).value);
    }

    public int hashCode() {
        return 31 * this.value.hashCode();
    }
}

