/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ResettableReadOnlyList<T>
implements List<T> {
    private T[] all;
    private final ResettableReadOnlyIterator iterator;
    private final T[] one = new Object[1];

    public ResettableReadOnlyList() {
        this.iterator = new ResettableReadOnlyIterator();
    }

    public <E> List<E> asList() {
        return this;
    }

    public void wrap(T[] all) {
        this.all = all;
        this.iterator.current = 0;
    }

    public void wrap(T all) {
        this.one[0] = all;
        this.all = this.one;
        this.iterator.current = 0;
    }

    @Override
    public int size() {
        return this.all.length;
    }

    @Override
    public boolean isEmpty() {
        return this.all.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public Iterator<T> iterator() {
        this.iterator.current = 0;
        return this.iterator;
    }

    @Override
    public Object[] toArray() {
        return this.all;
    }

    @Override
    public <A> A[] toArray(A[] a) {
        System.arraycopy(this.all, 0, a, 0, Math.min(this.all.length, a.length));
        return a;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public T get(int index) {
        return this.all[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Read-only access");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Must override");
    }

    private final class ResettableReadOnlyIterator
    implements Iterator<T> {
        private int current = 0;

        @Override
        public boolean hasNext() {
            return this.current < ResettableReadOnlyList.this.size();
        }

        @Override
        public T next() {
            return ResettableReadOnlyList.this.get(this.current++);
        }

        private ResettableReadOnlyIterator() {
        }
    }
}

