/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.compiler;

import io.vlingo.common.compiler.ByteCode;
import io.vlingo.common.compiler.DynaClassLoader;
import io.vlingo.common.compiler.DynaFile;
import io.vlingo.common.compiler.DynaFileManager;
import io.vlingo.common.compiler.DynaType;
import java.io.File;
import java.util.Arrays;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class DynaCompiler {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Class<T> compile(Input input) throws Exception {
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
        DynaDiagnosticListener listener = new DynaDiagnosticListener();
        try (DynaFileManager dynaFileManager = new DynaFileManager(input.protocol, fileManager, input.classLoader);){
            Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(input.sourceFile));
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, dynaFileManager, listener, null, null, sources);
            if (task.call() == false) throw new IllegalArgumentException("Dynamically generated class source did not compile: " + input.fullyQualifiedClassname);
            this.persist(input, dynaFileManager.byteCode);
            Class clazz = input.classLoader.addDynaClass(input.fullyQualifiedClassname, dynaFileManager.byteCode);
            return clazz;
        }
        catch (Exception e) {
            System.out.println("Dynamically generated class source for " + input.fullyQualifiedClassname + " did not compile because: " + e.getMessage());
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Dynamically generated class source did not compile: " + input.fullyQualifiedClassname);
    }

    private File persist(Input input, ByteCode byteCode) throws Exception {
        String relativePathToClass = DynaFile.toFullPath(input.fullyQualifiedClassname);
        String pathToCompiledClass = DynaFile.toPackagePath(input.fullyQualifiedClassname);
        String rootOfGenerated = input.type == DynaType.Main ? "target/classes/" : "target/test-classes/";
        new File(rootOfGenerated + pathToCompiledClass).mkdirs();
        String pathToClass = rootOfGenerated + relativePathToClass + ".class";
        return input.persist ? DynaFile.persistDynaClass(pathToClass, byteCode.bytes()) : new File(relativePathToClass);
    }

    private static class DynaDiagnosticListener<T extends JavaFileObject>
    implements DiagnosticListener<T> {
        private DynaDiagnosticListener() {
        }

        @Override
        public void report(Diagnostic<? extends T> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                System.out.println("vlingo/common: DynaCompiler ERROR: " + diagnostic);
            }
        }
    }

    public static class Input {
        public final DynaClassLoader classLoader;
        public final String fullyQualifiedClassname;
        public final boolean persist;
        public final Class<?> protocol;
        public final DynaType type;
        public final String source;
        public final File sourceFile;

        public <T> Input(Class<T> protocol, String fullyQualifiedClassname, String source, File sourceFile, DynaClassLoader classLoader, DynaType type, boolean persist) {
            this.protocol = protocol;
            this.fullyQualifiedClassname = fullyQualifiedClassname;
            this.source = source;
            this.sourceFile = sourceFile;
            this.classLoader = classLoader;
            this.type = type;
            this.persist = persist;
        }
    }
}

