/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.compiler;

import java.io.File;
import java.io.FileOutputStream;

public class DynaFile {
    public static final String GeneratedSources = "target/generated-sources/";
    public static final String GeneratedTestSources = "target/generated-test-sources/";
    public static final String RootOfMainClasses = "target/classes/";
    public static final String RootOfTestClasses = "target/test-classes/";

    public static File persistDynaClass(String pathToClass, byte[] dynaClass) throws Exception {
        File pathToClassFile = new File(pathToClass);
        try (FileOutputStream stream = new FileOutputStream(pathToClassFile);){
            stream.write(dynaClass);
            File file = pathToClassFile;
            return file;
        }
    }

    public static File persistDynaClassSource(String pathToSource, String dynaClassSource) throws Exception {
        File pathToSourceFile = new File(pathToSource);
        try (FileOutputStream stream = new FileOutputStream(pathToSourceFile);){
            stream.write(dynaClassSource.getBytes());
            File file = pathToSourceFile;
            return file;
        }
    }

    public static String toFullPath(String fullyQualifiedClassname) {
        return DynaFile.toPath(fullyQualifiedClassname, true);
    }

    public static String toPackagePath(String fullyQualifiedClassname) {
        return DynaFile.toPath(fullyQualifiedClassname, false);
    }

    private static String toPath(String fullyQualifiedClassname, boolean includeClassname) {
        String[] names = fullyQualifiedClassname.split("\\.");
        boolean first = true;
        int actualLength = names.length - (includeClassname ? 0 : 1);
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < actualLength; ++idx) {
            if (!first) {
                builder.append("/");
            }
            builder.append(names[idx]);
            first = false;
        }
        return builder.toString();
    }
}

