/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.completes;

import io.vlingo.common.Completes;
import io.vlingo.common.Scheduler;
import io.vlingo.common.completes.Sink;
import io.vlingo.common.completes.Source;
import io.vlingo.common.completes.operations.AndThen;
import io.vlingo.common.completes.operations.AndThenConsume;
import io.vlingo.common.completes.operations.AndThenToSource;
import io.vlingo.common.completes.operations.FailureGateway;
import io.vlingo.common.completes.operations.Otherwise;
import io.vlingo.common.completes.operations.OtherwiseConsume;
import io.vlingo.common.completes.operations.Recover;
import io.vlingo.common.completes.operations.TimeoutGateway;
import io.vlingo.common.completes.sinks.InMemorySink;
import io.vlingo.common.completes.sources.InMemorySource;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SinkAndSourceBasedCompletes<T>
implements Completes<T> {
    private static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private final Scheduler scheduler;
    public final Source<Object> source;
    private final Source<T> currentOperation;
    private final Sink<T> sink;

    protected SinkAndSourceBasedCompletes(Scheduler scheduler, Source<Object> source, Source<T> currentOperation, Sink<T> sink) {
        this.scheduler = scheduler;
        this.source = source;
        this.sink = sink;
        this.currentOperation = currentOperation;
    }

    protected SinkAndSourceBasedCompletes(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.source = new InMemorySource<Object>();
        this.sink = new InMemorySink<T>();
        this.currentOperation = this.source;
        this.source.subscribe(this.sink);
    }

    public static <T> SinkAndSourceBasedCompletes<T> withScheduler(Scheduler scheduler) {
        InMemorySource<Object> source = new InMemorySource<Object>();
        InMemorySink sink = new InMemorySink();
        source.subscribe(sink);
        return new SinkAndSourceBasedCompletes<Object>(scheduler, source, source, sink);
    }

    public static boolean isToggleActive() {
        return Boolean.parseBoolean(System.getProperty("vlingo.InMemoryCompletes", "false"));
    }

    @Override
    public <O> Completes<O> andThen(long timeout, O failedOutcomeValue, Function<T, O> function) {
        FailureGateway<O> failureGateway = new FailureGateway<O>(failedOutcomeValue);
        TimeoutGateway timeoutGateway = new TimeoutGateway(this.scheduler, timeout);
        AndThen<T, O> newSource = new AndThen<T, O>(function);
        this.currentOperation.subscribe(timeoutGateway);
        timeoutGateway.subscribe(newSource);
        newSource.subscribe(failureGateway);
        failureGateway.subscribe((InMemorySink)this.sink);
        return new SinkAndSourceBasedCompletes<O>(this.scheduler, this.source, failureGateway, (InMemorySink)this.sink);
    }

    @Override
    public <O> Completes<O> andThen(O failedOutcomeValue, Function<T, O> function) {
        return this.andThen(Long.MAX_VALUE, failedOutcomeValue, function);
    }

    @Override
    public <O> Completes<O> andThen(long timeout, Function<T, O> function) {
        return this.andThen(timeout, null, function);
    }

    @Override
    public <O> Completes<O> andThen(Function<T, O> function) {
        return this.andThen(Long.MAX_VALUE, null, function);
    }

    @Override
    public Completes<T> andThenConsume(long timeout, T failedOutcomeValue, Consumer<T> consumer) {
        FailureGateway<T> failureGateway = new FailureGateway<T>(failedOutcomeValue);
        TimeoutGateway timeoutGateway = new TimeoutGateway(this.scheduler, timeout);
        AndThenConsume<T> newSource = new AndThenConsume<T>(consumer);
        this.currentOperation.subscribe(timeoutGateway);
        timeoutGateway.subscribe(newSource);
        newSource.subscribe(failureGateway);
        failureGateway.subscribe(this.sink);
        return new SinkAndSourceBasedCompletes<T>(this.scheduler, this.source, failureGateway, this.sink);
    }

    @Override
    public Completes<T> andThenConsume(T failedOutcomeValue, Consumer<T> consumer) {
        return this.andThenConsume(Long.MAX_VALUE, failedOutcomeValue, consumer);
    }

    @Override
    public Completes<T> andThenConsume(long timeout, Consumer<T> consumer) {
        return this.andThenConsume(timeout, null, consumer);
    }

    @Override
    public Completes<T> andThenConsume(Consumer<T> consumer) {
        return this.andThenConsume(Long.MAX_VALUE, null, consumer);
    }

    @Override
    public <F, O> O andThenTo(long timeout, F failedOutcomeValue, Function<T, O> function) {
        FailureGateway<F> failureGateway = new FailureGateway<F>(failedOutcomeValue);
        TimeoutGateway timeoutGateway = new TimeoutGateway(this.scheduler, timeout);
        AndThenToSource<T, F> newSource = new AndThenToSource<T, F>(function.andThen((? super R e) -> (Completes)e).andThen(InMemorySource::fromCompletes));
        this.currentOperation.subscribe(timeoutGateway);
        timeoutGateway.subscribe(newSource);
        newSource.subscribe(failureGateway);
        failureGateway.subscribe((InMemorySink)this.sink);
        return (O)new SinkAndSourceBasedCompletes<F>(this.scheduler, this.source, failureGateway, (InMemorySink)this.sink);
    }

    @Override
    public <F, O> O andThenTo(F failedOutcomeValue, Function<T, O> function) {
        return this.andThenTo(Long.MAX_VALUE, failedOutcomeValue, function);
    }

    @Override
    public <O> O andThenTo(long timeout, Function<T, O> function) {
        return this.andThenTo(timeout, null, function);
    }

    @Override
    public <O> O andThenTo(Function<T, O> function) {
        return this.andThenTo(Long.MAX_VALUE, null, function);
    }

    @Override
    public <E> Completes<T> otherwise(Function<E, T> function) {
        Otherwise<E> otherwise = new Otherwise<E>(function);
        this.currentOperation.subscribe(otherwise);
        otherwise.subscribe(this.sink);
        return new SinkAndSourceBasedCompletes<E>(this.scheduler, this.source, otherwise, this.sink);
    }

    @Override
    public Completes<T> otherwiseConsume(Consumer<T> consumer) {
        OtherwiseConsume<T> otherwise = new OtherwiseConsume<T>(consumer);
        this.currentOperation.subscribe(otherwise);
        otherwise.subscribe(this.sink);
        return new SinkAndSourceBasedCompletes<T>(this.scheduler, this.source, otherwise, this.sink);
    }

    @Override
    public Completes<T> recoverFrom(Function<Exception, T> function) {
        Recover<T> newSource = new Recover<T>(function);
        this.currentOperation.subscribe(newSource);
        newSource.subscribe(this.sink);
        return new SinkAndSourceBasedCompletes<T>(this.scheduler, this.source, newSource, this.sink);
    }

    @Override
    public <O> O await() {
        return this.await(Long.MAX_VALUE);
    }

    @Override
    public <O> O await(long timeout) {
        this.source.activate();
        try {
            Optional<T> value = this.sink.await(timeout);
            if (value.isPresent()) {
                return (O)value.get();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public boolean isCompleted() {
        return this.sink.hasBeenCompleted();
    }

    @Override
    public boolean hasFailed() {
        return this.sink.hasFailed();
    }

    @Override
    public void failed() {
        this.source.emitError(new IllegalStateException("Forced failure in Completes"));
    }

    @Override
    public void failed(Exception exception) {
        this.source.emitError(exception);
    }

    @Override
    public boolean hasOutcome() {
        return this.sink.hasOutcome();
    }

    @Override
    public T outcome() {
        return (T)this.await();
    }

    @Override
    public Completes<T> repeat() {
        this.sink.repeat();
        return this;
    }

    @Override
    public Completes<T> timeoutWithin(long timeout) {
        return this;
    }

    @Override
    public <F> Completes<T> useFailedOutcomeOf(F failedOutcomeValue) {
        return this;
    }

    @Override
    public <O> Completes<O> andFinally() {
        return this.andFinally(value -> value);
    }

    @Override
    public <O> Completes<O> andFinally(Function<T, O> function) {
        Completes<O> edge = this.andThen(function);
        this.source.activate();
        return edge;
    }

    @Override
    public void andFinallyConsume(Consumer<T> consumer) {
        this.andThenConsume(consumer);
        this.source.activate();
    }

    @Override
    public <O> Completes<O> with(O outcome) {
        this.source.emitOutcome(outcome);
        return this;
    }

    public String toString() {
        return "SinkAndSourceBasedCompletes{scheduler=" + this.scheduler + ", source=" + this.source + ", currentOperation=" + this.currentOperation + ", sink=" + this.sink + '}';
    }
}

