/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.completes.operations;

import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import io.vlingo.common.Scheduler;
import io.vlingo.common.completes.Operation;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimeoutGateway<Receives>
extends Operation<Receives, Receives>
implements Scheduled<Void> {
    private final Scheduler scheduler;
    private final long timeout;
    private Cancellable cancellable;
    private AtomicBoolean didTimeout;

    public TimeoutGateway(Scheduler scheduler, long timeout) {
        this.scheduler = scheduler;
        this.timeout = timeout;
        this.didTimeout = new AtomicBoolean(false);
        this.startTimer();
    }

    @Override
    public void onOutcome(Receives receives) {
        if (!this.didTimeout.get()) {
            this.cancellable.cancel();
            this.emitOutcome(receives);
            this.startTimer();
        }
    }

    @Override
    public void intervalSignal(Scheduled<Void> scheduled, Void data) {
        this.emitError(new TimeoutException());
        this.didTimeout.set(true);
    }

    private void startTimer() {
        this.cancellable = this.scheduler.scheduleOnce(this, null, 0L, this.timeout);
        this.didTimeout.set(false);
    }
}

