/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.completes.sinks;

import io.vlingo.common.Failure;
import io.vlingo.common.Outcome;
import io.vlingo.common.Success;
import io.vlingo.common.completes.Sink;
import io.vlingo.common.completes.exceptions.FailedOperationException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class InMemorySink<Exposes>
implements Sink<Exposes> {
    private Queue<Outcome<Exception, Exposes>> outcomes = new ArrayDeque<Outcome<Exception, Exposes>>();
    private AtomicBoolean hasBeenCompleted = new AtomicBoolean(false);
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onOutcome(Exposes exposes) {
        this.outcomes.add(Success.of(exposes));
        this.latch.countDown();
    }

    @Override
    public void onError(Exception cause) {
        this.outcomes.add(Failure.of(cause));
        this.latch.countDown();
    }

    @Override
    public void onCompletion() {
        this.hasBeenCompleted.set(true);
        this.latch.countDown();
    }

    @Override
    public boolean hasBeenCompleted() {
        return this.hasBeenCompleted.get();
    }

    @Override
    public boolean hasOutcome() {
        return this.outcomes.size() > 0 && this.outcomes.peek().resolve(e -> e instanceof FailedOperationException, e -> true) != false;
    }

    @Override
    public boolean hasFailed() {
        return this.outcomes.size() > 0 && this.outcomes.peek().resolve(e -> true, e -> false) != false;
    }

    public Optional<Exposes> await() throws Exception {
        return this.await(Long.MAX_VALUE);
    }

    @Override
    public Optional<Exposes> await(long timeout) throws Exception {
        try {
            this.waitUntilOutcomeOrTimeout(timeout);
            Outcome<Exception, Exposes> currentOutcome = this.outcomes.peek();
            if (currentOutcome == null) {
                return Optional.empty();
            }
            return currentOutcome.resolve(this::unpackFailureValueIfAny, Optional::ofNullable);
        }
        catch (InterruptedException e) {
            return Optional.empty();
        }
    }

    @Override
    public void repeat() {
        this.latch = new CountDownLatch(1 + (int)this.latch.getCount());
    }

    private void waitUntilOutcomeOrTimeout(long timeout) throws Exception {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    private Optional<Exposes> unpackFailureValueIfAny(Exception exception) {
        return exception instanceof FailedOperationException ? Optional.ofNullable(((FailedOperationException)exception).failureValue) : Optional.empty();
    }

    public String toString() {
        return "InMemorySink{outcomes=" + this.outcomes + ", hasBeenCompleted=" + this.hasBeenCompleted + ", latch=" + this.latch + '}';
    }
}

