/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.completes.sources;

import io.vlingo.common.Completes;
import io.vlingo.common.completes.LazySource;
import io.vlingo.common.completes.Sink;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class InMemorySource<Exposes>
implements LazySource<Exposes> {
    private Queue<Consumer<Sink<Exposes>>> queue = new ArrayDeque<Consumer<Sink<Exposes>>>();
    private Sink<Exposes> subscriber = null;
    private AtomicBoolean active = new AtomicBoolean(false);

    @Override
    public void emitOutcome(Exposes outcome) {
        if (this.active.get()) {
            this.subscriber.onOutcome(outcome);
        } else {
            this.queue.add(e -> e.onOutcome(outcome));
        }
    }

    @Override
    public void emitError(Exception cause) {
        if (this.active.get()) {
            this.subscriber.onError(cause);
        } else {
            this.queue.add(e -> e.onError(cause));
        }
    }

    @Override
    public void emitCompletion() {
        if (this.active.get()) {
            this.subscriber.onCompletion();
        } else {
            this.queue.add(Sink::onCompletion);
        }
    }

    @Override
    public void subscribe(Sink<Exposes> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void activate() {
        if (this.subscriber == null) {
            throw new UnsupportedOperationException("Source must have a subscriber before being able to activate it.");
        }
        if (this.active.compareAndSet(false, true) && !this.queue.isEmpty()) {
            this.queue.forEach(e -> e.accept(this.subscriber));
            this.queue = null;
        }
    }

    public static <E> InMemorySource<E> fromCompletes(Completes<E> completes) {
        InMemorySource source = new InMemorySource();
        completes.andFinallyConsume(s -> {
            source.emitOutcome(s);
            source.emitCompletion();
        });
        return source;
    }

    public String toString() {
        return "InMemorySource{queue=" + this.queue + ", subscriber=" + this.subscriber + ", active=" + this.active + '}';
    }
}

