/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.config;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvVarProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Pattern envVarPattern = Pattern.compile("\\$\\{(?<envVar>[0-9a-zA-Z_]+)(:(?<default>[^\\}]+))?\\}");

    @Override
    public synchronized Object put(Object key, Object value) {
        this.ensureKeyAndValueAreStrings(key, value);
        StringBuffer interpolated = new StringBuffer();
        Matcher matcher = envVarPattern.matcher((String)value);
        while (matcher.find()) {
            String envVal = System.getenv(matcher.group("envVar"));
            String defaultVal = matcher.group("default");
            this.ensureValueOrDefault((String)key, envVal, defaultVal);
            matcher.appendReplacement(interpolated, envVal == null ? defaultVal : envVal);
        }
        matcher.appendTail(interpolated);
        return super.put(key, interpolated.toString());
    }

    private void ensureKeyAndValueAreStrings(Object key, Object value) {
        if (!(key instanceof String) || !(value instanceof String)) {
            throw new IllegalArgumentException("Both key and value need to be Strings");
        }
    }

    private void ensureValueOrDefault(String key, String envVal, String defaultVal) {
        if (envVal == null && defaultVal == null) {
            throw new IllegalArgumentException("Environment variable " + key + " not set and has no default.");
        }
    }
}

