/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.crypto;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import io.vlingo.common.crypto.Hasher;

public class Argon2Hasher
implements Hasher {
    private final Argon2 argon2 = Argon2Factory.create();
    private final int maxDuration;
    private final int memoryCost;
    private final int parallelism;

    public Argon2Hasher(int maxDuration, int memoryCost, int parallelism) {
        this.maxDuration = maxDuration;
        this.memoryCost = memoryCost;
        this.parallelism = parallelism;
    }

    @Override
    public String hash(String plainSecret) {
        String hash = this.argon2.hash(this.maxDuration, this.memoryCost, this.parallelism, plainSecret);
        return hash;
    }

    @Override
    public boolean verify(String plainSecret, String hashedSecret) {
        return this.argon2.verify(hashedSecret, plainSecret);
    }
}

