/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.crypto;

import io.vlingo.common.crypto.Argon2Hasher;
import io.vlingo.common.crypto.BCryptHasher;
import io.vlingo.common.crypto.SCryptHasher;
import java.util.Properties;

public interface Hasher {
    public static Hasher defaultHasher(Properties properties) {
        switch (properties.getProperty("crypto.type", "(unknown)")) {
            case "argon2": {
                int cryptoArgon2MaxDuration = Integer.parseInt(properties.getProperty("crypto.argon2.max.duration", "10"));
                int cryptoArgon2MemoryCost = Integer.parseInt(properties.getProperty("crypto.argon2.memory.cost", "65536"));
                int cryptoArgon2Parallelism = Integer.parseInt(properties.getProperty("crypto.argon2.parallelism", "1"));
                return new Argon2Hasher(cryptoArgon2MaxDuration, cryptoArgon2MemoryCost, cryptoArgon2Parallelism);
            }
            case "scrypt": {
                int cryptoScrypt_N_costFactor = Integer.parseInt(properties.getProperty("crypto.scrypt.N.cost.factor", "16384"));
                int cryptoScrypt_r_Blocksize = Integer.parseInt(properties.getProperty("crypto.scrypt.r.blocksize", "8"));
                int cryptoScrypt_p_parallelization = Integer.parseInt(properties.getProperty("crypto.scrypt.p.parallelization", "1"));
                return new SCryptHasher(cryptoScrypt_N_costFactor, cryptoScrypt_r_Blocksize, cryptoScrypt_p_parallelization);
            }
            case "bcrypt": {
                return new BCryptHasher();
            }
        }
        throw new IllegalStateException("Crypto type is not defined.");
    }

    public String hash(String var1);

    public boolean verify(String var1, String var2);
}

