/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.crypto;

import com.lambdaworks.crypto.SCryptUtil;
import io.vlingo.common.crypto.Hasher;

public class SCryptHasher
implements Hasher {
    private final int N_costFactor;
    private final int r_blocksize;
    private final int p_parallelization;

    public SCryptHasher(int N_costFactor, int r_blocksize, int p_parallelization) {
        this.N_costFactor = N_costFactor;
        this.r_blocksize = r_blocksize;
        this.p_parallelization = p_parallelization;
    }

    @Override
    public String hash(String plainSecret) {
        String hashed = SCryptUtil.scrypt((String)plainSecret, (int)this.N_costFactor, (int)this.r_blocksize, (int)this.p_parallelization);
        return hashed;
    }

    @Override
    public boolean verify(String plainSecret, String hashedSecret) {
        return SCryptUtil.check((String)plainSecret, (String)hashedSecret);
    }
}

