/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.identity;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.NameBasedGenerator;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.security.SecureRandom;
import java.util.UUID;

public interface IdentityGenerator {
    public UUID generate();

    public UUID generate(String var1);

    public static class TimeBasedIdentityGenerator
    implements IdentityGenerator {
        private final TimeBasedGenerator generator = Generators.timeBasedGenerator();

        @Override
        public UUID generate() {
            return this.generator.generate();
        }

        @Override
        public UUID generate(String name) {
            return this.generator.generate();
        }
    }

    public static class RandomIdentityGenerator
    implements IdentityGenerator {
        @Override
        public UUID generate() {
            return UUID.randomUUID();
        }

        @Override
        public UUID generate(String name) {
            return UUID.randomUUID();
        }
    }

    public static class NameBasedIdentityGenerator
    implements IdentityGenerator {
        private final NameBasedGenerator generator = Generators.nameBasedGenerator();
        private final SecureRandom random = new SecureRandom();

        @Override
        public UUID generate() {
            byte[] name = new byte[8];
            this.random.nextBytes(name);
            return this.generator.generate(name);
        }

        @Override
        public UUID generate(String name) {
            return this.generator.generate(name);
        }
    }
}

