/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.message;

import io.vlingo.common.message.Message;
import io.vlingo.common.message.MessageQueue;
import io.vlingo.common.message.MessageQueueListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncMessageQueue
implements MessageQueue,
Runnable {
    private final MessageQueue deadLettersQueue;
    private AtomicBoolean dispatching;
    private final ThreadPoolExecutor executor;
    private MessageQueueListener listener;
    private AtomicBoolean open;
    private final ConcurrentLinkedQueue<Message> queue;

    public AsyncMessageQueue() {
        this(null);
    }

    public AsyncMessageQueue(MessageQueue deadLettersQueue) {
        this.deadLettersQueue = deadLettersQueue;
        this.dispatching = new AtomicBoolean(false);
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        this.open = new AtomicBoolean(false);
        this.queue = new ConcurrentLinkedQueue();
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean flush) {
        if (this.open.get()) {
            this.open.set(false);
            if (flush) {
                this.flush();
            }
            this.executor.shutdownNow();
        }
    }

    @Override
    public void enqueue(Message message) {
        if (this.open.get()) {
            this.queue.add(message);
            this.executor.execute(this);
        }
    }

    @Override
    public void flush() {
        try {
            while (!this.queue.isEmpty()) {
                Thread.sleep(1L);
            }
            while (this.dispatching.get()) {
                Thread.sleep(1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() && !this.dispatching.get();
    }

    @Override
    public void registerListener(MessageQueueListener listener) {
        this.open.set(true);
        this.listener = listener;
    }

    @Override
    public void run() {
        Message message = null;
        try {
            this.dispatching.set(true);
            message = this.dequeue();
            if (message != null) {
                this.listener.handleMessage(message);
            }
        }
        catch (Exception e) {
            if (message != null && this.deadLettersQueue != null) {
                this.deadLettersQueue.enqueue(message);
            }
            System.out.println("AsyncMessageQueue: Dispatch to listener hasFailed because: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.dispatching.set(false);
        }
    }

    private Message dequeue() {
        return this.queue.poll();
    }
}

