/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.message;

import io.vlingo.common.message.Message;
import io.vlingo.common.message.MessageReader;
import java.math.BigDecimal;
import java.util.Date;

public class MessageExchangeReader
extends MessageReader {
    private final Message message;

    public static MessageExchangeReader from(Message message) {
        return new MessageExchangeReader(message);
    }

    public String id() {
        return this.message.id();
    }

    public long idAsLong() {
        return Long.parseLong(this.id());
    }

    public String type() {
        return this.message.type();
    }

    public BigDecimal payloadBigDecimalValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : new BigDecimal(stringValue);
    }

    public Boolean payloadBooleanValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(stringValue));
    }

    public Date payloadDateValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : new Date(Long.parseLong(stringValue));
    }

    public Double payloadDoubleValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Double.valueOf(Double.parseDouble(stringValue));
    }

    public Float payloadFloatValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Float.valueOf(Float.parseFloat(stringValue));
    }

    public Integer payloadIntegerValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Integer.valueOf(Integer.parseInt(stringValue));
    }

    public Long payloadLongValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Long.valueOf(Long.parseLong(stringValue));
    }

    public String payloadStringValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue;
    }

    private MessageExchangeReader(Message message) {
        super((String)message.payload());
        this.message = message;
    }
}

