/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.util.Date;

public abstract class MessageReader {
    private JsonObject representation;

    public MessageReader(String jsonRepresentation) {
        this.initialize(jsonRepresentation);
    }

    public MessageReader(JsonObject jsonRepresentation) {
        this.representation = jsonRepresentation;
    }

    public JsonArray array(String ... keys) {
        JsonArray array = null;
        JsonElement element = this.navigateTo(this.representation(), keys);
        if (element != null) {
            array = element.getAsJsonArray();
        }
        return array;
    }

    public BigDecimal bigDecimalValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : new BigDecimal(stringValue);
    }

    public Boolean booleanValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(stringValue));
    }

    public Date dateValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : new Date(Long.parseLong(stringValue));
    }

    public Double doubleValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Double.valueOf(Double.parseDouble(stringValue));
    }

    public Float floatValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Float.valueOf(Float.parseFloat(stringValue));
    }

    public Integer integerValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Integer.valueOf(Integer.parseInt(stringValue));
    }

    public Long longValue(String ... keys) {
        String stringValue = this.stringValue(keys);
        return stringValue == null ? null : Long.valueOf(Long.parseLong(stringValue));
    }

    public String stringValue(String ... keys) {
        return this.stringValue(this.representation(), keys);
    }

    public String[] stringArrayValue(String ... keys) {
        JsonArray array = this.array(keys);
        if (array != null) {
            int size = array.size();
            String[] stringArray = new String[size];
            for (int idx = 0; idx < size; ++idx) {
                stringArray[idx] = array.get(idx).getAsString();
            }
            return stringArray;
        }
        return new String[0];
    }

    protected JsonElement elementFrom(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (element == null) {
            element = jsonObject.get("@" + key);
        }
        return element;
    }

    protected JsonElement navigateTo(JsonObject startingJsonObject, String ... keys) {
        int keyIndex;
        if (keys.length == 0) {
            throw new IllegalArgumentException("Must specify one or more keys.");
        }
        JsonElement element = this.elementFrom(startingJsonObject, keys[0]);
        if (!(element.isJsonNull() || element.isJsonPrimitive() || element.isJsonArray())) {
            JsonObject object = element.getAsJsonObject();
            for (keyIndex = 1; element != null && !element.isJsonPrimitive() && keyIndex < keys.length; ++keyIndex) {
                element = this.elementFrom(object, keys[keyIndex]);
                if (element.isJsonPrimitive()) continue;
                element = this.elementFrom(object, keys[keyIndex]);
                if (element.isJsonNull()) {
                    element = null;
                    continue;
                }
                object = element.getAsJsonObject();
            }
        }
        if (element != null) {
            if (!element.isJsonNull()) {
                if (keyIndex != keys.length) {
                    throw new IllegalArgumentException("Last name must reference a simple value.");
                }
            } else {
                element = null;
            }
        }
        return element;
    }

    protected JsonObject parse(String jsonRepresentation) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(jsonRepresentation).getAsJsonObject();
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected JsonObject representation() {
        return this.representation;
    }

    protected String stringValue(JsonObject startingJsonObject, String ... keys) {
        String value = null;
        JsonElement element = this.navigateTo(startingJsonObject, keys);
        if (element != null) {
            value = element.getAsString();
        }
        return value;
    }

    private void initialize(String jsonRepresentation) {
        this.representation = this.parse(jsonRepresentation);
    }
}

