/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.pool;

import io.vlingo.common.pool.AbstractResourcePool;
import io.vlingo.common.pool.ResourceFactory;
import io.vlingo.common.pool.ResourcePoolStats;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ElasticResourcePool<Resource, Arguments>
extends AbstractResourcePool<Resource, Arguments> {
    private final AtomicInteger idle = new AtomicInteger(0);
    private final AtomicInteger allocations = new AtomicInteger(0);
    private final AtomicInteger evictions = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<Resource> cache = new ConcurrentLinkedQueue();
    private final int minIdle;

    public ElasticResourcePool(Config config, ResourceFactory<Resource, Arguments> factory) {
        this(config.minIdle, factory);
    }

    ElasticResourcePool(int minIdle, ResourceFactory<Resource, Arguments> factory) {
        super(factory);
        this.minIdle = minIdle;
        this.initialize();
    }

    private void initialize() {
        for (int i = 0; i < this.minIdle; ++i) {
            this.allocations.incrementAndGet();
            this.cache(this.factory.create(this.factory.defaultArguments()));
        }
    }

    private void cache(Resource resource) {
        this.idle.incrementAndGet();
        this.cache.offer(resource);
    }

    @Override
    public Resource acquire(Arguments arguments) {
        Resource resource = this.cache.poll();
        if (resource == null) {
            this.allocations.incrementAndGet();
            resource = this.factory.create(arguments);
        } else {
            this.idle.decrementAndGet();
            resource = this.factory.reset(resource, arguments);
        }
        return resource;
    }

    @Override
    public void release(Resource resource) {
        ResourcePoolStats stats = this.stats();
        if (stats.idleToInUse < (float)this.minIdle) {
            this.idle.incrementAndGet();
            this.cache.offer(resource);
        } else if (this.idle.get() > this.minIdle) {
            this.evict(resource);
            this.compact();
        } else {
            this.evict(resource);
        }
    }

    private void evict(Resource resource) {
        this.evictions.incrementAndGet();
        this.factory.destroy(resource);
    }

    private void compact() {
        while (this.idle.get() > this.target()) {
            Resource resource = this.cache.poll();
            if (resource == null) {
                return;
            }
            if (this.idle.getAndDecrement() > this.target()) {
                this.evict(resource);
                continue;
            }
            this.idle.incrementAndGet();
            this.cache.offer(resource);
        }
    }

    private int target() {
        return Math.max(this.minIdle, (int)((double)this.idle.get() * 0.5));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public ResourcePoolStats stats() {
        return new ResourcePoolStats(this.allocations.get(), this.evictions.get(), this.idle.get());
    }

    public static final class Config {
        final int minIdle;

        Config(int minIdle) {
            this.minIdle = minIdle;
        }

        public static Config of(int minIdle) {
            return new Config(minIdle);
        }
    }
}

