/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.pool;

import java.util.Objects;

public final class ResourcePoolStats {
    public final int allocations;
    public final int evictions;
    public final int idle;
    public final int inUse;
    public final float idleToInUse;

    public ResourcePoolStats(int allocations, int evictions, int idle) {
        this.allocations = allocations;
        this.evictions = evictions;
        this.idle = idle;
        this.inUse = allocations - evictions - idle;
        this.idleToInUse = (float)idle / (float)Math.max(1, this.inUse);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePoolStats that = (ResourcePoolStats)o;
        return this.allocations == that.allocations && this.evictions == that.evictions && this.idle == that.idle;
    }

    public int hashCode() {
        return Objects.hash(this.allocations, this.evictions, this.idle);
    }

    public String toString() {
        return String.format("ResourcePoolStats(allocations: %d, evictions: %d, idle: %d, inUse: %d, idleToInUse: %f)", this.allocations, this.evictions, this.idle, this.inUse, Float.valueOf(this.idleToInUse));
    }
}

