/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class JsonSerialization {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassSerializer()).registerTypeAdapter(Class.class, (Object)new ClassDeserializer()).registerTypeAdapter(Date.class, (Object)new DateSerializer()).registerTypeAdapter(Date.class, (Object)new DateDeserializer()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeSerializer()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeDeserializer()).create();

    public static <T> T deserialized(String serialization, Class<T> type) {
        Object instance = gson.fromJson(serialization, type);
        return (T)instance;
    }

    public static <T> T deserialized(String serialization, Type type) {
        Object instance = gson.fromJson(serialization, type);
        return (T)instance;
    }

    public static <T> List<T> deserializedList(String serialization, Type listOfType) {
        List list = (List)gson.fromJson(serialization, listOfType);
        return list;
    }

    public static String serialized(Object instance) {
        String serialization = gson.toJson(instance);
        return serialization;
    }

    public static <T> String serialized(Collection<T> instance) {
        Type collectionOfT = new TypeToken<Collection<T>>(){}.getType();
        String serialization = gson.toJson(instance, collectionOfT);
        return serialization;
    }

    public static <T> String serialized(List<T> instance) {
        Type listOfT = new TypeToken<List<T>>(){}.getType();
        String serialization = gson.toJson(instance, listOfT);
        return serialization;
    }

    private static class OffsetDateTimeDeserializer
    implements JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonElement json, Type typeOfTarget, JsonDeserializationContext context) throws JsonParseException {
            String[] encoding = json.getAsJsonPrimitive().getAsString().split(";");
            Date date = new Date(Long.parseLong(encoding[0]));
            return date.toInstant().atOffset(ZoneOffset.of(encoding[1]));
        }
    }

    private static class OffsetDateTimeSerializer
    implements JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
        }

        public JsonElement serialize(OffsetDateTime source, Type typeOfSource, JsonSerializationContext context) {
            return new JsonPrimitive(Long.toString(source.toInstant().toEpochMilli()) + ";" + source.getOffset().toString());
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfTarget, JsonDeserializationContext context) throws JsonParseException {
            long time = Long.parseLong(json.getAsJsonPrimitive().getAsString());
            return new Date(time);
        }
    }

    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date source, Type typeOfSource, JsonSerializationContext context) {
            return new JsonPrimitive(Long.toString(source.getTime()));
        }
    }

    private static class ClassDeserializer
    implements JsonDeserializer<Class> {
        private ClassDeserializer() {
        }

        public Class deserialize(JsonElement json, Type typeOfTarget, JsonDeserializationContext context) throws JsonParseException {
            String classname = json.getAsJsonPrimitive().getAsString();
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    private static class ClassSerializer
    implements JsonSerializer<Class> {
        private ClassSerializer() {
        }

        public JsonElement serialize(Class source, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(source.getName());
        }
    }
}

