/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common.version;

public class SemanticVersion {
    public static final int MAJOR_MASK = 0x7FFF0000;
    public static final int MAJOR_SHIFT = 16;
    public static final int MAJOR_MAX = Short.MAX_VALUE;
    public static final int MINOR_MASK = 65280;
    public static final int MINOR_SHIFT = 8;
    public static final int MINOR_MAX = 255;
    public static final int PATCH_MASK = 255;
    public static final int PATCH_MAX = 255;
    public final int major;
    public final int minor;
    public final int patch;

    public static SemanticVersion from(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch);
    }

    public static SemanticVersion from(String version) {
        String[] parts = version.split("\\.");
        if (parts.length == 3) {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = Integer.parseInt(parts[2]);
            return new SemanticVersion(major, minor, patch);
        }
        return new SemanticVersion(0, 0, 0);
    }

    public static SemanticVersion greatest() {
        return SemanticVersion.from(Short.MAX_VALUE, 255, 255);
    }

    public static String toString(int version) {
        return "" + (version >> 16) + "." + ((version & 0xFF00) >> 8) + "." + (version & 0xFF);
    }

    public static int toValue(int major, int minor, int patch) {
        if (major < 0 || major > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Major version must be 0 to 32767");
        }
        if (minor < 0 || minor > 255) {
            throw new IllegalArgumentException("Minor version must 0 to 255");
        }
        if (patch < 0 || patch > 255) {
            throw new IllegalArgumentException("Patch version must be 0 to 255");
        }
        return major << 16 & 0x7FFF0000 | minor << 8 & 0xFF00 | patch & 0xFF;
    }

    public static int toValue(String version) {
        String[] parts = version.split("\\.");
        if (parts.length == 3) {
            return SemanticVersion.toValue(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        return SemanticVersion.zero();
    }

    public static int zero() {
        return 0;
    }

    public boolean isCompatibleWith(SemanticVersion previous) {
        if (this.major == previous.major && this.minor == previous.minor && this.patch == previous.patch + 1) {
            return true;
        }
        if (this.major == previous.major && this.minor == previous.minor + 1 && this.patch == previous.patch) {
            return true;
        }
        return this.major == previous.major + 1 && this.minor == previous.minor && this.patch == previous.patch;
    }

    public boolean isGreaterThan(SemanticVersion version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return true;
        }
        return this.major == version.major && this.minor == version.minor && this.patch > version.patch;
    }

    public boolean isNonZero() {
        return this.major != 0 || this.minor != 0 || this.patch != 0;
    }

    public SemanticVersion withIncrementedMajor() {
        return new SemanticVersion(this.major + 1, this.minor, this.patch);
    }

    public SemanticVersion withIncrementedMinor() {
        return new SemanticVersion(this.major, this.minor + 1, this.patch);
    }

    public SemanticVersion withIncrementedPatch() {
        return new SemanticVersion(this.major, this.minor, this.patch + 1);
    }

    public SemanticVersion nextPatch() {
        return this.withIncrementedPatch();
    }

    public SemanticVersion nextMinor() {
        return new SemanticVersion(this.major, this.minor + 1, 0);
    }

    public SemanticVersion nextMajor() {
        return new SemanticVersion(this.major + 1, 0, 0);
    }

    public int hashCode() {
        return 31 * (this.major + this.minor + this.patch + 1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SemanticVersion otherVersion = (SemanticVersion)other;
        return this.major == otherVersion.major && this.minor == otherVersion.minor && this.patch == otherVersion.patch;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch;
    }

    public int toValue() {
        return SemanticVersion.toValue(this.major, this.minor, this.patch);
    }

    private SemanticVersion(int major, int minor, int patch) {
        assert (major >= 0 && major <= Short.MAX_VALUE);
        this.major = major;
        assert (minor >= 0 && minor <= 255);
        this.minor = minor;
        assert (patch >= 0 && patch <= 255);
        this.patch = patch;
    }
}

