/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.BinaryBody;
import io.vlingo.http.ChunkedBody;
import io.vlingo.http.PlainBody;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Base64;

public interface Body {
    public static final Body Empty = new PlainBody();

    public static ChunkedBody beginChunked() {
        return new ChunkedBody();
    }

    public static ChunkedBody beginChunkedWith(Body body) {
        return Body.beginChunked().appendChunk(body);
    }

    public static ChunkedBody beginChunkedWith(String content) {
        return Body.beginChunked().appendChunk(content);
    }

    public static Body empty() {
        return Empty;
    }

    public static Body from(byte[] body, Encoding encoding) {
        switch (encoding) {
            case Base64: {
                return new PlainBody(Body.bytesToBase64(body));
            }
            case UTF8: {
                return new PlainBody(Body.bytesToUTF8(body));
            }
            case None: {
                return new BinaryBody(body);
            }
        }
        throw new IllegalArgumentException("Unmapped encoding: " + (Object)((Object)encoding));
    }

    public static Body from(ByteBuffer body, Encoding encoding) {
        switch (encoding) {
            case Base64: {
                return new PlainBody(Body.bytesToBase64(Body.bufferToArray(body)));
            }
            case UTF8: {
                return new PlainBody(Body.bytesToUTF8(Body.bufferToArray(body)));
            }
            case None: {
                return new BinaryBody(Body.bufferToArray(body));
            }
        }
        throw new IllegalArgumentException("Unmapped encoding: " + (Object)((Object)encoding));
    }

    public static Body from(byte[] body) {
        return Body.from(body, Encoding.Base64);
    }

    public static Body from(ByteBuffer body) {
        return new PlainBody(Body.bytesToBase64(Body.bufferToArray(body)));
    }

    public static PlainBody from(String body) {
        return new PlainBody(body);
    }

    public String content();

    public byte[] binaryContent();

    default public boolean isComplex() {
        return false;
    }

    public boolean hasContent();

    public static byte[] bufferToArray(ByteBuffer body) {
        if (body.position() > 0) {
            body.flip();
        }
        int length = body.limit();
        byte[] bytes = new byte[length];
        System.arraycopy(body.array(), 0, bytes, 0, length);
        return bytes;
    }

    public static String bytesToBase64(byte[] body) {
        String encoded = Base64.getEncoder().encodeToString(body);
        return encoded;
    }

    public static String bytesToUTF8(byte[] body) {
        String encoded = new String(body, Charset.forName("UTF-8"));
        return encoded;
    }

    public static enum Encoding {
        Base64,
        UTF8,
        None;

    }
}

