/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.Body;
import io.vlingo.http.PlainBody;

public class ChunkedBody
implements Body {
    private final StringBuilder content = new StringBuilder();

    public ChunkedBody appendChunk(Body body) {
        return this.appendChunk(body.content());
    }

    public ChunkedBody appendChunk(String chunk) {
        this.content.append(Integer.toHexString(chunk.length())).append("\r\n").append(chunk).append("\r\n");
        return this;
    }

    public ChunkedBody appendChunk(byte[] chunk) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Adding chunks in the form of byte[] is not yet supported");
    }

    public Body asPlainBody() {
        return new PlainBody(this.content());
    }

    @Override
    public String content() {
        return this.toString();
    }

    @Override
    public byte[] binaryContent() {
        return this.toString().getBytes();
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public ChunkedBody end() {
        this.content.append(0).append("\r\n");
        return this;
    }

    @Override
    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public String toString() {
        return this.content.toString();
    }

    ChunkedBody() {
    }
}

