/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.RequestHeader;
import io.vlingo.http.ResponseHeader;

public class ContentType {
    public final String mediaType;
    public final String charset;
    public final String boundary;

    public static ContentType of(String mediaType) {
        return new ContentType(mediaType, "", "");
    }

    public static ContentType of(String mediaType, String charset) {
        return new ContentType(mediaType, charset, "");
    }

    public static ContentType of(String mediaType, String charset, String boundary) {
        return new ContentType(mediaType, charset, boundary);
    }

    public RequestHeader toRequestHeader() {
        return RequestHeader.contentType(this.toString());
    }

    public ResponseHeader toResponseHeader() {
        return ResponseHeader.contentType(this.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.mediaType.isEmpty()) {
            builder.append(this.mediaType);
            if (!this.charset.isEmpty()) {
                builder.append("; ").append(this.charset);
            }
            if (!this.boundary.isEmpty()) {
                builder.append("; ").append(this.boundary);
            }
        }
        return builder.toString();
    }

    private ContentType(String mediaType, String charset, String boundary) {
        this.mediaType = mediaType;
        this.charset = charset;
        this.boundary = boundary;
    }
}

