/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.common.Tuple2;
import io.vlingo.http.Filter;
import io.vlingo.http.Request;
import io.vlingo.http.RequestFilter;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseFilter;
import java.util.Collections;
import java.util.List;

public class Filters {
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private boolean stopped;

    public static Filters are(List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters) {
        return new Filters(requestFilters, responseFilters);
    }

    public static Filters none() {
        return new Filters(Collections.emptyList(), Collections.emptyList());
    }

    public static List<RequestFilter> noRequestFilters() {
        return Collections.emptyList();
    }

    public static List<ResponseFilter> noResponseFilters() {
        return Collections.emptyList();
    }

    public Request process(Request request) {
        if (this.stopped) {
            return request;
        }
        Request current = request;
        for (RequestFilter filter : this.requestFilters) {
            Tuple2<Request, Boolean> answer = filter.filter(current);
            if (!((Boolean)answer._2).booleanValue()) {
                return (Request)answer._1;
            }
            current = (Request)answer._1;
        }
        return current;
    }

    public Response process(Response response) {
        if (this.stopped) {
            return response;
        }
        Response current = response;
        for (ResponseFilter filter : this.responseFilters) {
            Tuple2<Response, Boolean> answer = filter.filter(current);
            if (!((Boolean)answer._2).booleanValue()) {
                return (Response)answer._1;
            }
            current = (Response)answer._1;
        }
        return current;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        for (Filter filter : this.requestFilters) {
            filter.stop();
        }
        for (Filter filter : this.responseFilters) {
            filter.stop();
        }
    }

    private Filters(List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters) {
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.stopped = false;
    }
}

