/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.RequestHeader;
import io.vlingo.http.ResponseHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Header {
    public static final String ValueWildcardAny = "*";
    public static final String ValueBr = "br";
    public static final String ValueClose = "close";
    public static final String ValueCompress = "compress";
    public static final String ValueDeflate = "deflate";
    public static final String ValueGZip = "gzip";
    public static final String ValueIdentity = "identity";
    public static final String ValueISO_8859_15 = "iso-8859-15";
    public static final String ValueKeepAlive = "keep-alive";
    public static final String ValueUTF_8 = "utf-8";
    public final String name;
    public final String value;

    protected Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public boolean matchesNameOf(Header header) {
        return this.name.equalsIgnoreCase(header.name);
    }

    public boolean matchesNameOf(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public boolean matchesValueOf(Header header) {
        return this.value.equals(header.value);
    }

    public boolean matchesValueOf(String value) {
        return this.value.equals(value);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Header otherHeader = (Header)other;
        return this.matchesNameOf(otherHeader) && this.matchesValueOf(otherHeader);
    }

    public String toString() {
        return "" + this.name + ": " + this.value;
    }

    public static class Headers<T extends Header>
    extends ArrayList<T>
    implements List<T> {
        private static final long serialVersionUID = 1L;

        public static Headers<RequestHeader> of(RequestHeader ... requestHeaders) {
            Headers<RequestHeader> headers = new Headers<RequestHeader>(requestHeaders.length);
            for (RequestHeader requestHeader : requestHeaders) {
                headers.add(requestHeader);
            }
            return headers;
        }

        public static Headers<ResponseHeader> of(ResponseHeader ... responseHeaders) {
            Headers<ResponseHeader> headers = new Headers<ResponseHeader>(responseHeaders.length);
            for (ResponseHeader responseHeader : responseHeaders) {
                headers.add(responseHeader);
            }
            return headers;
        }

        public T headerOf(String name) {
            return this.headerOfOrDefault(name, null);
        }

        public T headerOfOrDefault(String name, T defaultHeader) {
            for (Header header : this) {
                if (!header.matchesNameOf(name)) continue;
                return (T)header;
            }
            return defaultHeader;
        }

        public static <T extends Header> Headers<T> empty() {
            return new Headers<T>(0);
        }

        public Headers<T> and(Headers<? extends Header> headers) {
            for (Header header : headers) {
                this.and(header);
            }
            return this;
        }

        public Headers<T> and(Header header) {
            Header modified = null;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                if (!((Header)this.get(index)).matchesNameOf(header)) continue;
                modified = this.set(index, header);
                break;
            }
            if (modified == null) {
                this.add(header);
            }
            return this;
        }

        public Headers<T> and(String name, String value) {
            this.and(new Header(name, value));
            return this;
        }

        public Headers<T> copy() {
            Headers<T> headers = new Headers<T>(this.size());
            for (Header header : this) {
                headers.add(header);
            }
            return headers;
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next()).append("\n");
            }
            return builder.toString();
        }

        Headers(int initialCapactiy) {
            super(initialCapactiy);
        }
    }
}

