/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryParameters {
    private final Map<String, List<String>> allParameters;

    public QueryParameters(String query) {
        this.allParameters = this.parseQuery(query);
    }

    public Collection<String> names() {
        return this.allParameters.keySet();
    }

    public List<String> valuesOf(String name) {
        return Collections.unmodifiableList(this.allParameters.get(name));
    }

    private Map<String, List<String>> parseQuery(String query) {
        HashMap<String, List<String>> queryParameters;
        if (query == null || query.isEmpty()) {
            queryParameters = new HashMap<String, List<String>>();
        } else {
            try {
                String[] parameters = query.split("&");
                queryParameters = new HashMap(parameters.length);
                for (String parameter : parameters) {
                    String value;
                    if (parameter.isEmpty()) continue;
                    int equalSign = parameter.indexOf("=");
                    String name = equalSign > 0 ? URLDecoder.decode(parameter.substring(0, equalSign), "UTF-8") : parameter;
                    String string = value = equalSign > 0 && parameter.length() > equalSign + 1 ? URLDecoder.decode(parameter.substring(equalSign + 1), "UTF-8") : null;
                    if (!queryParameters.containsKey(name)) {
                        queryParameters.put(name, new ArrayList(2));
                    }
                    ((List)queryParameters.get(name)).add(value);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Query parameters invalid: " + query, e);
            }
        }
        return queryParameters;
    }

    public boolean containsKey(String key) {
        return this.allParameters.containsKey(key);
    }
}

