/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.Body;
import io.vlingo.http.ChunkedBody;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.QueryParameters;
import io.vlingo.http.RequestHeader;
import io.vlingo.http.RequestParser;
import io.vlingo.http.Version;
import java.net.URI;
import java.nio.ByteBuffer;

public class Request {
    public final Body body;
    public final Header.Headers<RequestHeader> headers;
    public final Method method;
    public final URI uri;
    public final Version version;

    public static Request from(ByteBuffer requestContent) {
        return RequestParser.parserFor(requestContent).fullRequest();
    }

    public static Request from(Method method, URI uri, Version version, Header.Headers<RequestHeader> headers, Body body) {
        return new Request(method, uri, version, headers, body);
    }

    public static Request has(Method method) {
        return new Request(method);
    }

    public Request and(Body body) {
        return new Request(this.method, this.uri, this.version, this.headers, body);
    }

    public Request and(ChunkedBody body) {
        return new Request(this.method, this.uri, this.version, this.headers, body.asPlainBody());
    }

    public Request and(RequestHeader header) {
        Header.Headers headers = Header.Headers.empty();
        return new Request(this.method, this.uri, this.version, headers.and(this.headers).and(header), this.body);
    }

    public Request and(Header.Headers<RequestHeader> headers) {
        return new Request(this.method, this.uri, this.version, headers, this.body);
    }

    public Request and(URI uri) {
        return new Request(this.method, uri, this.version, this.headers, this.body);
    }

    public Request and(Version version) {
        return new Request(this.method, this.uri, version, this.headers, this.body);
    }

    public static Request method(Method method) {
        return new Request(method);
    }

    public Request body(String body) {
        return new Request(this.method, this.uri, this.version, this.headers, Body.from(body));
    }

    public Request header(String name, String value) {
        Header.Headers headers = Header.Headers.empty();
        return new Request(this.method, this.uri, this.version, headers.and(this.headers).and(RequestHeader.of(name, value)), this.body);
    }

    public Request header(String name, int value) {
        return this.header(name, String.valueOf(value));
    }

    public Request uri(String uri) {
        return new Request(this.method, URI.create(uri), this.version, this.headers, this.body);
    }

    public Request version(String version) {
        return new Request(this.method, this.uri, Version.from(version), this.headers, this.body);
    }

    public Header headerOf(String name) {
        for (Header header : this.headers) {
            if (!header.matchesNameOf(name)) continue;
            return header;
        }
        return null;
    }

    public boolean headerMatches(String name, String value) {
        Header header = this.headerOf(name);
        return header == null ? false : header.matchesValueOf(value);
    }

    public String headerValueOr(String headerName, String defaultValue) {
        Header header = this.headerOf(headerName);
        return header == null ? defaultValue : header.value;
    }

    public QueryParameters queryParameters() {
        return new QueryParameters(this.uri.getQuery());
    }

    public String toString() {
        return "" + (Object)((Object)this.method) + " " + this.uri + " " + (Object)((Object)this.version) + "\n" + this.headers + "\n" + this.body;
    }

    Request(Method method, URI uri, Version version, Header.Headers<RequestHeader> headers, Body body) {
        this.method = method;
        this.uri = uri;
        this.version = version;
        this.body = body;
        this.headers = body != null && body.hasContent() && headers.headerOf("Content-Length") == null ? headers.and("Content-Length", body.content().length() + "") : headers;
    }

    private Request(Method method) {
        this(method, URI.create("/"), Version.Http1_1, Header.Headers.empty(), Body.from(""));
    }
}

