/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.Body;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.RequestHeader;
import io.vlingo.http.Response;
import io.vlingo.http.Version;
import io.vlingo.wire.message.Converters;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Queue;
import java.util.StringTokenizer;

public class RequestParser {
    private final VirtualStateParser virtualStateParser;

    public String currentRequestText() {
        return this.virtualStateParser.requestText;
    }

    public static RequestParser parserFor(ByteBuffer requestContent) {
        return new RequestParser(requestContent);
    }

    public boolean hasCompleted() {
        return this.virtualStateParser.hasCompleted();
    }

    public Request fullRequest() {
        return this.virtualStateParser.fullRequest();
    }

    public boolean hasFullRequest() {
        return this.virtualStateParser.hasFullRequest();
    }

    public boolean hasMissingContentTimeExpired(long timeLimit) {
        return this.virtualStateParser.hasMissingContentTimeExpired(timeLimit);
    }

    public boolean isMissingContent() {
        return this.virtualStateParser.isMissingContent();
    }

    public void parseNext(ByteBuffer requestContent) {
        this.virtualStateParser.includes(requestContent).parse();
    }

    private RequestParser(ByteBuffer requestContent) {
        this.virtualStateParser = new VirtualStateParser().includes(requestContent).parse();
    }

    static class VirtualStateParser {
        private final Queue<String> contentQueue = new LinkedList<String>();
        private int position;
        private String requestText = "";
        private Body body;
        private int contentLength;
        private boolean continuation;
        private Step currentStep = Step.NotStarted;
        private List<Request> fullRequests;
        private ListIterator<Request> fullRequestsIterator;
        private Header.Headers<RequestHeader> headers = new Header.Headers(2);
        private Method method;
        private long outOfContentTime;
        private URI uri;
        private Version version;

        VirtualStateParser() {
            this.fullRequests = new ArrayList<Request>(2);
            this.reset();
        }

        Request fullRequest() {
            if (this.fullRequestsIterator == null) {
                this.fullRequestsIterator = this.fullRequests.listIterator();
            }
            if (this.fullRequestsIterator.hasNext()) {
                Request fullRequest = this.fullRequestsIterator.next();
                this.fullRequestsIterator.remove();
                return fullRequest;
            }
            throw new IllegalStateException((Object)((Object)Response.Status.BadRequest) + "\n\nRequest is not completed: " + (Object)((Object)this.method) + " " + this.uri);
        }

        boolean hasFullRequest() {
            if (this.fullRequestsIterator != null) {
                if (!this.fullRequestsIterator.hasNext()) {
                    this.fullRequestsIterator = null;
                    return false;
                }
                return true;
            }
            if (this.fullRequests.isEmpty()) {
                this.fullRequestsIterator = null;
                return false;
            }
            return true;
        }

        boolean hasCompleted() {
            if (this.isNotStarted() && this.position >= this.requestText.length() && this.contentQueue.isEmpty()) {
                this.requestText = this.compact();
                return true;
            }
            return false;
        }

        boolean hasMissingContentTimeExpired(long timeLimit) {
            long timeOutTime = this.outOfContentTime + timeLimit;
            return timeOutTime < System.currentTimeMillis();
        }

        VirtualStateParser includes(ByteBuffer requestContent) {
            this.outOfContentTime = 0L;
            String requestContentText = Converters.bytesToText((byte[])requestContent.array(), (int)0, (int)requestContent.limit());
            if (this.contentQueue.isEmpty()) {
                this.requestText = this.requestText.concat(requestContentText);
            } else {
                this.contentQueue.add(requestContentText);
            }
            return this;
        }

        boolean isMissingContent() {
            return this.outOfContentTime > 0L;
        }

        VirtualStateParser parse() {
            boolean isOutOfContent = false;
            while (!this.hasCompleted()) {
                if (this.isNotStarted()) {
                    isOutOfContent = this.nextStep();
                } else if (this.isRequestLineStep()) {
                    isOutOfContent = this.parseRequestLine();
                } else if (this.isHeadersStep()) {
                    isOutOfContent = this.parseHeaders();
                } else if (this.isBodyStep()) {
                    isOutOfContent = this.parseBody();
                } else if (this.isCompletedStep()) {
                    this.continuation = false;
                    isOutOfContent = this.newRequest();
                }
                if (!isOutOfContent) continue;
                this.continuation = true;
                this.outOfContentTime = System.currentTimeMillis();
                return this;
            }
            return this;
        }

        private String compact() {
            String compact = this.requestText.substring(this.position);
            this.position = 0;
            return compact;
        }

        private Optional<String> nextLine(String errorResult, String errorMessage) {
            int possibleCarriageReturnIndex = -1;
            int lineBreak = this.requestText.indexOf("\n", this.position);
            if (lineBreak < 0) {
                if (this.contentQueue.isEmpty()) {
                    this.requestText = this.compact();
                    return Optional.empty();
                }
                this.requestText = this.compact().concat(this.contentQueue.poll());
                return this.nextLine(errorResult, errorMessage);
            }
            if (lineBreak == 0) {
                possibleCarriageReturnIndex = 0;
            }
            int endOfLine = this.requestText.charAt(lineBreak + possibleCarriageReturnIndex) == '\r' ? lineBreak - 1 : lineBreak;
            String line = this.requestText.substring(this.position, endOfLine).trim();
            this.position = lineBreak + 1;
            return Optional.of(line);
        }

        private boolean nextStep() {
            if (this.isNotStarted()) {
                this.currentStep = Step.RequestLine;
            } else if (this.isRequestLineStep()) {
                this.currentStep = Step.Headers;
            } else if (this.isHeadersStep()) {
                this.currentStep = Step.Body;
            } else if (this.isBodyStep()) {
                this.currentStep = Step.Completed;
            } else if (this.isCompletedStep()) {
                this.currentStep = Step.NotStarted;
            }
            return false;
        }

        private boolean isBodyStep() {
            return this.currentStep == Step.Body;
        }

        private boolean isCompletedStep() {
            return this.currentStep == Step.Completed;
        }

        private boolean isHeadersStep() {
            return this.currentStep == Step.Headers;
        }

        private boolean isNotStarted() {
            return this.currentStep == Step.NotStarted;
        }

        private boolean isRequestLineStep() {
            return this.currentStep == Step.RequestLine;
        }

        private boolean parseBody() {
            this.continuation = false;
            if (this.contentLength > 0) {
                int endIndex = this.position + this.contentLength;
                if (this.requestText.length() < endIndex) {
                    if (this.contentQueue.isEmpty()) {
                        this.requestText = this.compact();
                        return true;
                    }
                    this.requestText = this.compact() + this.contentQueue.poll();
                    this.parseBody();
                } else {
                    this.body = Body.from(this.requestText.substring(this.position, endIndex));
                    this.position += this.contentLength;
                    this.nextStep();
                }
            } else {
                this.body = Body.from("");
                this.nextStep();
            }
            return false;
        }

        private boolean parseHeaders() {
            if (!this.continuation) {
                this.headers = new Header.Headers(8);
            }
            this.continuation = false;
            while (true) {
                int maybeContentLength;
                Optional<String> maybeHeaderLine;
                if (!(maybeHeaderLine = this.nextLine(Response.Status.BadRequest.toString(), "\n\nHeader is required.")).isPresent()) {
                    return true;
                }
                String headerLine = maybeHeaderLine.get();
                if (headerLine.isEmpty()) break;
                RequestHeader header = RequestHeader.from(headerLine);
                this.headers.add(header);
                if (this.contentLength != 0 || (maybeContentLength = header.ifContentLength()) <= 0) continue;
                this.contentLength = maybeContentLength;
            }
            if (this.headers.isEmpty()) {
                throw new IllegalArgumentException((Object)((Object)Response.Status.BadRequest) + "\n\nHeader is required.");
            }
            return this.nextStep();
        }

        private boolean parseRequestLine() {
            this.continuation = false;
            Optional<String> maybeLine = this.nextLine(Response.Status.BadRequest.toString(), "\n\nRequest line is required.");
            if (!maybeLine.isPresent()) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(maybeLine.get(), " ");
            try {
                this.method = Method.from(this.parseNextRequestLinePart(tokenizer, "Method"));
                this.uri = new URI(this.parseNextRequestLinePart(tokenizer, "URI/path"));
                this.version = Version.from(this.parseNextRequestLinePart(tokenizer, "HTTP/version"));
                return this.nextStep();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(Response.Status.BadRequest.toString() + "\n\nParsing exception: " + e.getMessage(), e);
            }
        }

        private String parseNextRequestLinePart(StringTokenizer tokenizer, String expectedPartName) {
            if (tokenizer.hasMoreTokens()) {
                return tokenizer.nextToken();
            }
            throw new IllegalArgumentException((Object)((Object)Response.Status.BadRequest) + "\n\nRequest line part missing: " + expectedPartName);
        }

        private boolean newRequest() {
            Request request = new Request(this.method, this.uri, this.version, this.headers, this.body);
            this.fullRequests.add(request);
            this.reset();
            return this.nextStep();
        }

        private void reset() {
            this.body = null;
            this.contentLength = 0;
            this.continuation = false;
            this.method = null;
            this.outOfContentTime = 0L;
            this.version = null;
            this.uri = null;
        }

        private static enum Step {
            NotStarted,
            RequestLine,
            Headers,
            Body,
            Completed;

        }
    }
}

