/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.Body;
import io.vlingo.http.Header;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.Version;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.Converters;
import java.util.function.Function;

public class Response {
    public final Status status;
    public final String statusCode;
    public final Header.Headers<ResponseHeader> headers;
    public final Body entity;
    public final Version version;

    public static Response of(Status statusCode) {
        return new Response(Version.Http1_1, statusCode, Header.Headers.empty(), Body.from(""));
    }

    public static Response of(Version version, Status statusCode) {
        return new Response(version, statusCode, Header.Headers.empty(), Body.from(""));
    }

    public static Response of(Status statusCode, String entity) {
        return new Response(Version.Http1_1, statusCode, Header.Headers.empty(), Body.from(entity));
    }

    public static Response of(Status statusCode, byte[] entity) {
        return new Response(Version.Http1_1, statusCode, Header.Headers.empty(), Body.from(entity));
    }

    public static Response of(Version version, Status statusCode, String entity) {
        return new Response(version, statusCode, Header.Headers.empty(), Body.from(entity));
    }

    public static Response of(Version version, Status statusCode, byte[] entity) {
        return new Response(version, statusCode, Header.Headers.empty(), Body.from(entity));
    }

    public static Response of(Status statusCode, Header.Headers<ResponseHeader> headers) {
        return new Response(Version.Http1_1, statusCode, headers, Body.from(""));
    }

    public static Response of(Version version, Status statusCode, Header.Headers<ResponseHeader> headers) {
        return new Response(version, statusCode, headers, Body.from(""));
    }

    public static Response of(Status statusCode, Header.Headers<ResponseHeader> headers, String entity) {
        return new Response(Version.Http1_1, statusCode, headers, Body.from(entity));
    }

    public static Response of(Status statusCode, Header.Headers<ResponseHeader> headers, byte[] entity) {
        return new Response(Version.Http1_1, statusCode, headers, Body.from(entity));
    }

    public static Response of(Version version, Status statusCode, Header.Headers<ResponseHeader> headers, String entity) {
        return new Response(version, statusCode, headers, Body.from(entity));
    }

    public static Response of(Version version, Status statusCode, Header.Headers<ResponseHeader> headers, byte[] entity) {
        return new Response(version, statusCode, headers, Body.from(entity));
    }

    public static Response of(Status statusCode, Body body) {
        return new Response(Version.Http1_1, statusCode, Header.Headers.empty(), body);
    }

    public static Response of(Status statusCode, Header.Headers<ResponseHeader> headers, Body entity) {
        return new Response(Version.Http1_1, statusCode, headers, entity);
    }

    public static Response of(Version version, Status statusCode, Header.Headers<ResponseHeader> headers, Body entity) {
        return new Response(version, statusCode, headers, entity);
    }

    public Header headerOf(String name) {
        for (Header header : this.headers) {
            if (!header.name.equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public boolean headerMatches(String name, String value) {
        Header header = this.headerOf(name);
        return header == null ? false : header.matchesValueOf(value);
    }

    public String headerValueOr(String headerName, String defaultValue) {
        Header header = this.headerOf(headerName);
        return header == null ? defaultValue : header.value;
    }

    public Response include(Header header) {
        if (header != null && this.headerOf(header.name) == null) {
            this.headers.and(ResponseHeader.of(header.name, header.value));
        }
        return this;
    }

    public ConsumerByteBuffer into(ConsumerByteBuffer buffer) {
        Function<String, byte[]> convert = Converters::textToBytes;
        Function<byte[], ConsumerByteBuffer> put = arg_0 -> ((ConsumerByteBuffer)buffer).put(arg_0);
        return this.into(convert.andThen(put)).flip();
    }

    public int size() {
        int headersSize = 0;
        for (ResponseHeader header : this.headers) {
            headersSize += header.name.length() + 2 + header.value.length() + 1;
        }
        return 9 + this.status.toString().length() + 1 + headersSize + 1 + this.entity.content().length() + 5;
    }

    private <R> R into(Function<String, R> appender) {
        appender.apply("HTTP/1.1");
        appender.apply(" ");
        appender.apply(this.status.toString());
        appender.apply("\n");
        this.appendAllHeadersTo(appender);
        appender.apply("\n");
        return appender.apply(this.entity.toString());
    }

    public String toString() {
        return this.into(new StringBuilder(this.size())::append).toString();
    }

    protected Response(Version version, Status status, Header.Headers<ResponseHeader> headers, Body entity) {
        this.version = version;
        this.status = status;
        this.statusCode = String.valueOf(status.code);
        this.entity = this.entityFrom(headers, entity);
        this.headers = this.addMissingContentLengthHeader(headers);
    }

    private Header.Headers<ResponseHeader> addMissingContentLengthHeader(Header.Headers<ResponseHeader> headers) {
        if (!this.entity.isComplex()) {
            int contentLength = this.entity.content().length();
            ResponseHeader header = headers.headerOf("Content-Length");
            if (header == null && contentLength > 0) {
                headers.add(ResponseHeader.of("Content-Length", Integer.toString(contentLength)));
            }
        }
        return headers;
    }

    private <R> void appendAllHeadersTo(Function<String, R> appender) {
        for (ResponseHeader header : this.headers) {
            appender.apply(header.name);
            appender.apply(": ");
            appender.apply(header.value);
            appender.apply("\n");
        }
    }

    private Body entityFrom(Header.Headers<ResponseHeader> headers, Body entity) {
        ResponseHeader header = headers.headerOf("Transfer-Encoding");
        if (header != null && header.value.equals("chunked") && entity.isComplex() && !entity.hasContent()) {
            return Body.beginChunked();
        }
        return entity;
    }

    public static enum Status {
        Continue(100, "Continue"),
        SwitchingProtocols(101, "Switching Protocols"),
        Processing(102, "Processing"),
        EarlyHints(103, "Early Hints"),
        Ok(200, "OK"),
        Created(201, "Created"),
        Accepted(202, "Accepted"),
        NonAuthoritativeInformation(203, "Non-Authoritative Information"),
        NoContent(204, "No Content"),
        ResetContent(205, "Reset Content"),
        PartialContent(206, "Partial Content"),
        MultiStatus(207, "Multi-Status"),
        AlreadyReported(208, "Already Reported"),
        IMUsed(226, "IM Used"),
        MultipleChoices(300, "Multiple Choices"),
        MovedPermanently(301, "Moved Permanently"),
        Found(302, "Found"),
        SeeOther(303, "See Other"),
        NotModified(304, "Not Modified"),
        UseProxy(305, "Use Proxy"),
        SwitchProxy(306, "Switch Proxy"),
        TemporaryRedirect(307, "Temporary Redirect"),
        PermanentRedirect(308, "Permanent Redirect"),
        BadRequest(400, "Bad Request"),
        Unauthorized(401, "Unauthorized"),
        PaymentRequired(402, "Payment Required"),
        Forbidden(403, "Forbidden"),
        NotFound(404, "Not Found"),
        MethodNotAllowed(405, "Method Not Allowed"),
        NotAcceptable(406, "Not Acceptable"),
        ProxyAuthenticationRequired(407, "Proxy Authentication Required"),
        RequestTimeout(408, "Request Timeout"),
        Conflict(409, "Conflict"),
        Gone(410, "Gone"),
        LengthRequired(411, "Length Required"),
        PreconditionFailed(412, "Precondition Failed"),
        PayloadTooLarge(413, "Payload Too Large"),
        URITooLong(414, "URI Too Long"),
        UnsupportedMediaType(415, "Unsupported Media Type"),
        RangeNotSatisfiable(416, "Range Not Satisfiable"),
        ExpectationFailed(417, "Expectation Failed"),
        Imateapot(418, "I'm a teapot"),
        MisdirectedRequest(421, "Misdirected Request"),
        UnprocessableEntity(422, "Unprocessable Entity"),
        Locked(423, "Locked"),
        FailedDependency(424, "Failed Dependency"),
        UpgradeRequired(426, "Upgrade Required"),
        PreconditionRequired(428, "Precondition Required"),
        TooManyRequests(429, "Too Many Requests"),
        RequestHeaderFieldsTooLarge(431, "Request Header Fields Too Large"),
        UnavailableForLegalReasons(451, "Unavailable For Legal Reasons"),
        InternalServerError(500, "Internal Server Error"),
        NotImplemented(501, "Not Implemented"),
        BadGateway(502, "Bad Gateway"),
        ServiceUnavailable(503, "Service Unavailable"),
        GatewayTimeout(504, "Gateway Timeout"),
        HTTPVersionNotSupported(505, "HTTP Version Not Supported"),
        VariantAlsoNegotiates(506, "Variant Also Negotiates"),
        InsufficientStorage(507, "Insufficient Storage"),
        LoopDetected(508, "Loop Detected"),
        NotExtended(510, "Not Extended"),
        NetworkAuthenticationRequired(511, "Network Authentication Required");

        public final int code;
        public final String reason;

        private Status(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public String toString() {
            return "" + this.code + ' ' + this.reason;
        }

        public static Status valueOfRawState(String value) {
            for (Status status : Status.values()) {
                if (!status.toString().toLowerCase().equals(value.toLowerCase())) continue;
                return status;
            }
            throw new IllegalArgumentException("status " + value + " is not valid");
        }
    }
}

