/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

import io.vlingo.http.Body;
import io.vlingo.http.Header;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.Version;
import io.vlingo.wire.message.Converters;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;

public class ResponseParser {
    private final VirtualStateParser virtualStateParser;

    public static ResponseParser parserFor(ByteBuffer requestContent) {
        return new ResponseParser(requestContent);
    }

    public static ResponseParser parserForBodyOnly(ByteBuffer requestContent) {
        return new ResponseParser(requestContent, true);
    }

    public boolean hasCompleted() {
        return this.virtualStateParser.hasCompleted();
    }

    public Response fullResponse() {
        return this.virtualStateParser.fullResponse();
    }

    public boolean hasFullResponse() {
        return this.virtualStateParser.hasFullResponse();
    }

    public boolean hasMissingContentTimeExpired(long timeLimit) {
        return this.virtualStateParser.hasMissingContentTimeExpired(timeLimit);
    }

    public boolean isKeepAliveConnection() {
        return this.virtualStateParser.isKeepAliveConnection();
    }

    public boolean isMissingContent() {
        return this.virtualStateParser.isMissingContent();
    }

    public boolean isStreamContentType() {
        return this.virtualStateParser.isStreamContentType();
    }

    public void parseNext(ByteBuffer responseContent) {
        this.virtualStateParser.includes(responseContent).parse();
    }

    private ResponseParser(ByteBuffer responseContent) {
        this.virtualStateParser = new VirtualStateParser().includes(responseContent).parse();
    }

    private ResponseParser(ByteBuffer responseContent, boolean bodyOnly) {
        this.virtualStateParser = new VirtualStateParser(bodyOnly).includes(responseContent).parse();
    }

    static class VirtualStateParser {
        private final Queue<String> contentQueue;
        private int position;
        private String responseText;
        private int currentResponseTextLength;
        private boolean transferEncodingChunked;
        private Body body;
        private boolean bodyOnly;
        private int contentLength;
        private boolean continuation;
        private Step currentStep;
        private List<Response> fullResponses;
        private ListIterator<Response> fullResponsesIterator;
        private Header.Headers<ResponseHeader> headers;
        private boolean keepAlive;
        private long outOfContentTime;
        private Response.Status status;
        private boolean stream;
        private Version version;

        VirtualStateParser() {
            this(false);
        }

        VirtualStateParser(boolean bodyOnly) {
            this.bodyOnly = bodyOnly;
            this.contentQueue = new LinkedList<String>();
            this.currentStep = Step.NotStarted;
            this.responseText = "";
            this.headers = new Header.Headers(2);
            this.fullResponses = new ArrayList<Response>(2);
            this.keepAlive = false;
            this.stream = false;
            this.reset();
        }

        Response fullResponse() {
            if (this.fullResponsesIterator == null) {
                this.fullResponsesIterator = this.fullResponses.listIterator();
            }
            if (this.fullResponsesIterator.hasNext()) {
                Response fullResponse = this.fullResponsesIterator.next();
                this.fullResponsesIterator.remove();
                return fullResponse;
            }
            this.fullResponsesIterator = null;
            throw new IllegalStateException("Response is not completed.");
        }

        boolean hasFullResponse() {
            if (this.fullResponsesIterator != null) {
                if (!this.fullResponsesIterator.hasNext()) {
                    this.fullResponsesIterator = null;
                    return false;
                }
                return true;
            }
            if (this.fullResponses.isEmpty()) {
                this.fullResponsesIterator = null;
                return false;
            }
            return true;
        }

        boolean hasCompleted() {
            if (this.isNotStarted() && this.position >= this.currentResponseTextLength && this.contentQueue.isEmpty()) {
                this.responseText = this.compact();
                return true;
            }
            return false;
        }

        boolean hasMissingContentTimeExpired(long timeLimit) {
            long timeOutTime = this.outOfContentTime + timeLimit;
            return timeOutTime < System.currentTimeMillis();
        }

        VirtualStateParser includes(ByteBuffer responseContent) {
            this.outOfContentTime = 0L;
            String responseContentText = Converters.bytesToText((byte[])responseContent.array(), (int)0, (int)responseContent.limit());
            if (this.contentQueue.isEmpty()) {
                this.responseText = this.responseText + responseContentText;
                this.currentResponseTextLength = this.responseText.length();
            } else {
                this.contentQueue.add(responseContentText);
            }
            return this;
        }

        boolean isKeepAliveConnection() {
            return this.keepAlive;
        }

        boolean isMissingContent() {
            return this.outOfContentTime > 0L;
        }

        boolean isStreamContentType() {
            return this.stream;
        }

        VirtualStateParser parse() {
            while (!this.hasCompleted()) {
                try {
                    if (this.isNotStarted()) {
                        this.nextStep();
                        continue;
                    }
                    if (this.isStatusLineStep()) {
                        this.parseStatusLine();
                        continue;
                    }
                    if (this.isHeadersStep()) {
                        this.parseHeaders();
                        continue;
                    }
                    if (this.isBodyStep()) {
                        this.parseBody();
                        continue;
                    }
                    if (!this.isCompletedStep()) continue;
                    this.continuation = false;
                    this.newResponse();
                }
                catch (OutOfContentException e) {
                    this.continuation = true;
                    this.outOfContentTime = System.currentTimeMillis();
                    return this;
                }
                catch (Throwable t) {
                    throw t;
                }
            }
            this.prepareForStream();
            return this;
        }

        private void clearContent() {
            this.responseText = "";
            this.currentResponseTextLength = 0;
            this.position = 0;
        }

        private String compact() {
            String compact = this.responseText.substring(this.position);
            this.position = 0;
            this.currentResponseTextLength = compact.length();
            return compact;
        }

        private String nextLine(boolean mayBeBlank, String errorMessage) {
            int possibleCarriageReturnIndex = -1;
            int lineBreak = this.responseText.indexOf("\n", this.position);
            if (lineBreak < 0) {
                if (this.contentQueue.isEmpty()) {
                    this.responseText = this.compact();
                    throw new OutOfContentException();
                }
                this.responseText = this.compact() + this.contentQueue.poll();
                return this.nextLine(mayBeBlank, errorMessage);
            }
            if (lineBreak == 0) {
                possibleCarriageReturnIndex = 0;
            }
            int endOfLine = this.responseText.charAt(lineBreak + possibleCarriageReturnIndex) == '\r' ? lineBreak - 1 : lineBreak;
            String line = this.responseText.substring(this.position, endOfLine).trim();
            this.position = lineBreak + 1;
            return line;
        }

        private void nextStep() {
            if (this.isNotStarted()) {
                this.currentStep = Step.StatusLine;
            } else if (this.isStatusLineStep()) {
                this.currentStep = Step.Headers;
            } else if (this.isHeadersStep()) {
                this.currentStep = Step.Body;
            } else if (this.isBodyStep()) {
                this.currentStep = Step.Completed;
            } else if (this.isCompletedStep()) {
                this.currentStep = Step.NotStarted;
            }
        }

        private boolean isBodyStep() {
            return this.currentStep == Step.Body;
        }

        private boolean isCompletedStep() {
            return this.currentStep == Step.Completed;
        }

        private boolean isHeadersStep() {
            return this.currentStep == Step.Headers;
        }

        private boolean isNotStarted() {
            return this.currentStep == Step.NotStarted;
        }

        private boolean isStatusLineStep() {
            return this.currentStep == Step.StatusLine;
        }

        private void parseBody() {
            if (this.bodyOnly) {
                this.contentLength = this.responseText.length();
            }
            this.continuation = false;
            if (this.contentLength > 0) {
                int endIndex = this.position + this.contentLength;
                if (this.currentResponseTextLength < endIndex) {
                    if (this.contentQueue.isEmpty()) {
                        this.responseText = this.compact();
                        throw new OutOfContentException();
                    }
                    this.responseText = this.compact() + this.contentQueue.poll();
                    this.parseBody();
                    return;
                }
                this.body = Body.from(this.responseText.substring(this.position, endIndex));
                this.position += this.contentLength;
            } else {
                this.body = this.transferEncodingChunked ? Body.from(this.parseChunks()) : Body.empty();
            }
            this.nextStep();
        }

        private String parseBodyChunk(int chunkLength) {
            int endIndex = this.position + chunkLength;
            if (this.currentResponseTextLength < endIndex) {
                if (this.contentQueue.isEmpty()) {
                    this.responseText = this.compact();
                    throw new OutOfContentException();
                }
                this.responseText = this.compact() + this.contentQueue.poll();
            }
            String chunk = this.responseText.substring(this.position, endIndex);
            this.position += chunk.length();
            return chunk;
        }

        private String parseChunks() {
            StringBuilder builder = new StringBuilder();
            int chunkLength = this.chunkLength();
            while (chunkLength > 0) {
                String chunk = this.parseBodyChunk(chunkLength);
                builder.append(chunk);
                chunkLength = this.chunkLength();
            }
            this.clearContent();
            return builder.toString();
        }

        private void parseHeaders() {
            String maybeHeaderLine;
            if (this.bodyOnly) {
                this.nextStep();
                return;
            }
            if (!this.continuation) {
                this.headers = new Header.Headers(2);
            }
            this.continuation = false;
            while (!(maybeHeaderLine = this.nextLine(true, null)).isEmpty()) {
                ResponseHeader header = ResponseHeader.from(maybeHeaderLine);
                this.headers.add(header);
                if (this.contentLength == 0) {
                    int maybeContentLength = header.ifContentLength();
                    if (maybeContentLength >= 0) {
                        this.contentLength = maybeContentLength;
                    } else if (header.isTransferEncodingChunked()) {
                        this.transferEncodingChunked = true;
                    }
                }
                if (!this.keepAlive && header.isKeepAliveConnection()) {
                    this.keepAlive = true;
                    continue;
                }
                if (this.stream || !header.isStreamContentType()) continue;
                this.stream = true;
            }
            this.nextStep();
        }

        private void parseStatusLine() {
            if (this.bodyOnly) {
                this.version = Version.Http1_1;
                this.status = Response.Status.Ok;
                this.nextStep();
                return;
            }
            this.continuation = false;
            String line = this.nextLine(false, "Response status line is required.");
            int spaceIndex = line.indexOf(32);
            try {
                this.version = Version.from(line.substring(0, spaceIndex).trim());
                this.status = Response.Status.valueOfRawState(line.substring(spaceIndex + 1).trim());
                this.nextStep();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Response status line parsing exception: " + e.getMessage(), e);
            }
        }

        private void prepareForStream() {
            if (!this.bodyOnly && this.keepAlive && this.stream) {
                this.bodyOnly = true;
            }
        }

        private void newResponse() {
            Response response = Response.of(this.version, this.status, this.headers, this.body);
            this.fullResponses.add(response);
            this.reset();
            this.nextStep();
        }

        private void reset() {
            this.body = null;
            this.contentLength = 0;
            this.continuation = false;
            this.outOfContentTime = 0L;
            this.status = null;
            this.version = null;
            this.transferEncodingChunked = false;
        }

        private int chunkLength() {
            try {
                String line = this.nextLine(false, "Missing chunk length.");
                if (line.isEmpty()) {
                    line = this.nextLine(false, "Missing chunk length.");
                }
                return Integer.parseInt(line, 16);
            }
            catch (Exception e) {
                return 0;
            }
        }

        private static enum Step {
            NotStarted,
            StatusLine,
            Headers,
            Body,
            Completed;

        }

        private static class OutOfContentException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private OutOfContentException() {
            }
        }
    }
}

