/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http;

public enum Version {
    Http1_0{

        @Override
        public boolean isHttp1_0() {
            return true;
        }
    }
    ,
    Http1_1{

        @Override
        public boolean isHttp1_1() {
            return true;
        }
    }
    ,
    Http2_0{

        @Override
        public boolean isHttp2_0() {
            return true;
        }
    };

    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    public static final String HTTP_2_0 = "HTTP/2.0";

    public static Version from(String version) {
        if (version.equals(HTTP_1_0)) {
            return Http1_0;
        }
        if (version.equals(HTTP_1_1)) {
            return Http1_1;
        }
        if (version.equals(HTTP_2_0)) {
            return Http2_0;
        }
        throw new IllegalArgumentException("Unsupported HTTP/version: " + version);
    }

    public boolean isHttp1_0() {
        return false;
    }

    public boolean isHttp1_1() {
        return false;
    }

    public boolean isHttp2_0() {
        return false;
    }

    public String toString() {
        if (this.isHttp1_0()) {
            return HTTP_1_0;
        }
        if (this.isHttp1_1()) {
            return HTTP_1_1;
        }
        if (this.isHttp2_0()) {
            return HTTP_2_0;
        }
        return "HTTP/version unsupported";
    }
}

