/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.media;

import io.vlingo.http.media.MediaTypeDescriptor;
import io.vlingo.http.media.MediaTypeParser;
import io.vlingo.http.resource.MediaTypeNotSupportedException;
import java.util.Map;

public class ContentMediaType
extends MediaTypeDescriptor {
    public ContentMediaType(String mediaType, String mediaSubType) {
        super(mediaType, mediaSubType);
        this.validate();
    }

    private void validate() {
        mimeTypes.valueOf(this.mimeType);
        if (this.mimeSubType.equals("*")) {
            throw new MediaTypeNotSupportedException("Illegal MIME type:" + this.toString());
        }
    }

    public ContentMediaType(String mediaType, String mediaSubType, Map<String, String> parameters) {
        super(mediaType, mediaSubType, parameters);
        this.validate();
    }

    public ContentMediaType toBaseType() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return new ContentMediaType(this.mimeType, this.mimeSubType);
    }

    public static ContentMediaType Json() {
        return new ContentMediaType(mimeTypes.application.name(), "json");
    }

    public static ContentMediaType Xml() {
        return new ContentMediaType(mimeTypes.application.name(), "xml");
    }

    public static ContentMediaType parseFromDescriptor(String contentMediaTypeDescriptor) {
        return MediaTypeParser.parseFrom(contentMediaTypeDescriptor, new MediaTypeDescriptor.Builder<ContentMediaType>(ContentMediaType::new));
    }

    static enum mimeTypes {
        application,
        audio,
        font,
        image,
        model,
        text,
        video,
        multipart,
        message;

    }
}

