/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.media;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class MediaTypeDescriptor {
    static final String PARAMETER_SEPARATOR = ";";
    static final String MIME_SUBTYPE_SEPARATOR = "/";
    static final String PARAMETER_ASSIGNMENT = "=";
    protected final String mimeType;
    protected final String mimeSubType;
    public final Map<String, String> parameters;

    public MediaTypeDescriptor(String mimeType, String mimeSubType, Map<String, String> parameters) {
        this.mimeType = mimeType;
        this.mimeSubType = mimeSubType;
        this.parameters = new HashMap<String, String>(parameters);
    }

    public MediaTypeDescriptor(String mimeType, String mimeSubType) {
        this.mimeType = mimeType;
        this.mimeSubType = mimeSubType;
        this.parameters = new HashMap<String, String>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mimeType).append(MIME_SUBTYPE_SEPARATOR).append(this.mimeSubType);
        for (String parameterName : this.parameters.keySet()) {
            sb.append(PARAMETER_SEPARATOR).append(parameterName).append(PARAMETER_ASSIGNMENT).append(this.parameters.get(parameterName));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaTypeDescriptor that = (MediaTypeDescriptor)o;
        return Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.mimeSubType, that.mimeSubType) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.mimeType, this.mimeSubType, this.parameters);
    }

    public static class Builder<T> {
        protected String mimeType;
        protected String mimeSubType;
        protected Map<String, String> parameters;
        protected final Supplier<T> supplier;

        public Builder(Supplier<T> supplier) {
            this.supplier = supplier;
            this.parameters = new HashMap<String, String>();
            this.mimeType = "";
            this.mimeSubType = "";
        }

        Builder<T> withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        Builder<T> withMimeSubType(String mimeSubType) {
            this.mimeSubType = mimeSubType;
            return this;
        }

        Builder<T> withParameter(String paramName, String paramValue) {
            this.parameters.put(paramName, paramValue);
            return this;
        }

        T build() {
            return this.supplier.supply(this.mimeType, this.mimeSubType, this.parameters);
        }

        @FunctionalInterface
        public static interface Supplier<U> {
            public U supply(String var1, String var2, Map<String, String> var3);
        }
    }
}

