/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.media;

import io.vlingo.http.media.MediaTypeDescriptor;
import java.util.Arrays;

public class MediaTypeParser {
    private static final int MIME_TYPE_AND_SUBTYPE_SIZE = 2;
    private static final int PARAMETER_VALUE_OFFSET = 1;
    private static final int PARAMETER_FIELD_OFFSET = 0;
    private static final int PARAMETER_AND_VALUE_SIZE = 2;

    public static <T extends MediaTypeDescriptor> T parseFrom(String mediaTypeDescriptor, MediaTypeDescriptor.Builder<T> builder) {
        String[] mimeParts;
        String[] descriptorParts = mediaTypeDescriptor.split(";");
        if (descriptorParts.length > 1) {
            MediaTypeParser.parseAttributes(builder, Arrays.copyOfRange(descriptorParts, 1, descriptorParts.length));
        }
        if ((mimeParts = descriptorParts[0].split("/")).length == 2) {
            builder.withMimeType(mimeParts[0].trim()).withMimeSubType(mimeParts[1].trim());
        }
        return (T)((MediaTypeDescriptor)builder.build());
    }

    private static <T extends MediaTypeDescriptor> void parseAttributes(MediaTypeDescriptor.Builder<T> builder, String[] parameters) {
        for (String parameter : parameters) {
            String[] parameterFieldAndValue = parameter.split("=");
            if (parameterFieldAndValue.length != 2) continue;
            String attributeName = parameterFieldAndValue[0];
            String value = parameterFieldAndValue[1];
            builder.withParameter(attributeName, value);
        }
    }
}

