/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.media;

import io.vlingo.http.media.ContentMediaType;
import io.vlingo.http.media.MediaTypeDescriptor;
import io.vlingo.http.media.MediaTypeParser;
import io.vlingo.http.resource.MediaTypeNotSupportedException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class ResponseMediaTypeSelector {
    private static final String ACCEPT_MEDIA_TYPE_SEPARATOR = ",";
    private final TreeSet<AcceptMediaType> responseMediaTypesByPriority = new TreeSet();
    private final String mediaTypeDescriptors;

    public ResponseMediaTypeSelector(String mediaTypeDescriptors) {
        this.mediaTypeDescriptors = mediaTypeDescriptors;
        this.parseMediaTypeDescriptors(mediaTypeDescriptors);
    }

    private void parseMediaTypeDescriptors(String contentTypeList) {
        String[] acceptedContentTypeDescriptors;
        for (String acceptedContentTypeDescriptor : acceptedContentTypeDescriptors = contentTypeList.split(ACCEPT_MEDIA_TYPE_SEPARATOR)) {
            AcceptMediaType acceptMediaType = MediaTypeParser.parseFrom(acceptedContentTypeDescriptor.trim(), new MediaTypeDescriptor.Builder<AcceptMediaType>(AcceptMediaType::new));
            this.responseMediaTypesByPriority.add(acceptMediaType);
        }
    }

    public ContentMediaType selectType(ContentMediaType[] supportedContentMediaTypes) {
        Iterator<AcceptMediaType> iteratorMediaTypeCandidates = this.responseMediaTypesByPriority.descendingIterator();
        while (iteratorMediaTypeCandidates.hasNext()) {
            AcceptMediaType responseMediaType = iteratorMediaTypeCandidates.next();
            for (ContentMediaType supportedContentMediaType : supportedContentMediaTypes) {
                if (!responseMediaType.isSameOrSuperTypeOf(supportedContentMediaType)) continue;
                return supportedContentMediaType;
            }
        }
        throw new MediaTypeNotSupportedException(this.mediaTypeDescriptors);
    }

    static class AcceptMediaType
    extends MediaTypeDescriptor
    implements Comparable<AcceptMediaType> {
        private static final String MIME_TYPE_WILDCARD = "*";
        private static final String QUALITY_FACTOR_PARAMETER = "q";
        private static final float DEFAULT_QUALITY_FACTOR_VALUE = 1.0f;
        private final float qualityFactor;

        AcceptMediaType(String mimeType, String mimeSubType, Map<String, String> parameters) {
            super(mimeType, mimeSubType, parameters);
            float qualityFactor = 1.0f;
            if (parameters.containsKey(QUALITY_FACTOR_PARAMETER)) {
                try {
                    qualityFactor = Float.parseFloat(parameters.get(QUALITY_FACTOR_PARAMETER));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.qualityFactor = qualityFactor;
        }

        AcceptMediaType(String mimeType, String mimeSubType) {
            super(mimeType, mimeSubType);
            this.qualityFactor = 1.0f;
        }

        @Override
        public int compareTo(AcceptMediaType other) {
            if (this.qualityFactor == other.qualityFactor) {
                if (this.isGenericType() && !other.isGenericType()) {
                    return -1;
                }
                if (!this.isGenericType() && other.isGenericType()) {
                    return 1;
                }
                if (this.isGenericSubType()) {
                    return other.isGenericSubType() ? this.compareParameters(other) : -1;
                }
                return other.isGenericSubType() ? 1 : this.compareParameters(other);
            }
            return Float.compare(this.qualityFactor, other.qualityFactor);
        }

        private int compareParameters(AcceptMediaType other) {
            return Integer.compare(this.parameters.size(), other.parameters.size());
        }

        boolean isSameOrSuperTypeOf(ContentMediaType contentMediaType) {
            return !(!this.isGenericType() && !this.mimeType.equals(contentMediaType.mimeType) || !this.isGenericSubType() && !this.mimeSubType.equals(contentMediaType.mimeSubType));
        }

        private boolean isGenericSubType() {
            return this.mimeSubType.equals(MIME_TYPE_WILDCARD);
        }

        private boolean isGenericType() {
            return this.mimeType.equals(MIME_TYPE_WILDCARD);
        }
    }
}

