/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.common.Tuple2;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.resource.DefaultJsonMapper;
import io.vlingo.http.resource.Mapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Action {
    static final MatchResults unmatchedResults = new MatchResults(null, null, Collections.emptyList(), "");
    public final List<MappedParameter> additionalParameters;
    public final int id;
    public final Method method;
    public final String uri;
    public final String originalTo;
    public final ToSpec to;
    public final Mapper mapper;
    private final Matchable matchable;

    public Action(int id, String method, String uri, String to, String mapper) {
        this(id, method, uri, to, mapper, Collections.emptyList());
    }

    public Action(int id, String method, String uri, String to, String mapper, List<MappedParameter> additionalParameters) {
        this.id = id;
        this.method = Method.from(method);
        this.uri = uri;
        this.to = new ToSpec(to);
        this.originalTo = to;
        this.mapper = mapper == null ? DefaultJsonMapper.instance : this.mapperFrom(mapper);
        this.additionalParameters = additionalParameters;
        this.matchable = new Matchable(uri);
    }

    MappedParameters map(Request request, List<RawPathParameter> parameters) {
        ArrayList<MappedParameter> mapped = new ArrayList<MappedParameter>(parameters.size());
        for (MethodParameter typed : this.to.parameters) {
            if (typed.isBody()) {
                Object body = this.mapBodyFrom(request);
                mapped.add(new MappedParameter(typed.type, body));
                continue;
            }
            RawPathParameter raw = RawPathParameter.named(typed.name, parameters);
            if (raw == null) break;
            Object other = this.mapOtherFrom(raw);
            mapped.add(new MappedParameter(typed.type, other));
        }
        mapped.addAll(this.additionalParameters);
        return new MappedParameters(this.id, this.method, this.to.methodName, mapped);
    }

    private int indexOfNextSegmentStart(int currentIndex, String path) {
        int nextSegmentStart = path.indexOf("/", currentIndex);
        if (nextSegmentStart < currentIndex) {
            return path.length();
        }
        return nextSegmentStart;
    }

    MatchResults matchWith(Method method, URI uri) {
        if (this.method.equals((Object)method)) {
            String path = uri.getPath();
            int pathCurrentIndex = 0;
            int totalSegments = this.matchable.totalSegments();
            RunningMatchSegments running = new RunningMatchSegments(totalSegments);
            for (int idx = 0; idx < totalSegments; ++idx) {
                PathSegment segment = this.matchable.pathSegment(idx);
                if (segment.isPathParameter()) {
                    running.keepParameterSegment(pathCurrentIndex);
                    pathCurrentIndex = this.indexOfNextSegmentStart(pathCurrentIndex, path);
                    continue;
                }
                int indexOfSegment = path.indexOf(segment.value, pathCurrentIndex);
                if (indexOfSegment == -1 || pathCurrentIndex == 0 && indexOfSegment != 0) {
                    return unmatchedResults;
                }
                int lastIndex = segment.lastIndexOf(indexOfSegment);
                running.keepPathSegment(indexOfSegment, lastIndex);
                pathCurrentIndex = lastIndex;
            }
            int nextPathSegmentIndex = this.indexOfNextSegmentStart(pathCurrentIndex, path);
            if (nextPathSegmentIndex != path.length() && nextPathSegmentIndex < path.length() - 1) {
                return unmatchedResults;
            }
            MatchResults matchResults = new MatchResults(this, running, this.parameterNames(), path);
            return matchResults;
        }
        return unmatchedResults;
    }

    public int hashCode() {
        return 31 * (this.method.hashCode() + this.uri.hashCode() + this.to.hashCode() + this.mapper.hashCode() + this.matchable.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Action.class) {
            return false;
        }
        Action otherAction = (Action)other;
        return this.method.equals((Object)otherAction.method) && this.uri.equals(otherAction.uri) && this.to.equals(otherAction.to);
    }

    public String toString() {
        return "Action[id=" + this.id + ", method=" + (Object)((Object)this.method) + ", uri=" + this.uri + ", to=" + this.to + "]";
    }

    private Mapper mapperFrom(String mapper) {
        try {
            Class<?> mapperClass = Class.forName(mapper);
            return (Mapper)mapperClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load mapper class: " + mapper);
        }
    }

    private int parameterCount() {
        int count = 0;
        for (PathSegment segment : this.matchable.pathSegments) {
            if (!segment.pathParameter) continue;
            ++count;
        }
        return count;
    }

    private Object mapBodyFrom(Request request) {
        MethodParameter body = this.to.body();
        if (body != null) {
            return this.mapper.from(request.body.toString(), body.bodyType);
        }
        return null;
    }

    private Object mapOtherFrom(RawPathParameter parameter) {
        String type;
        switch (type = this.to.parameterOf((String)parameter.name).type) {
            case "String": {
                return parameter.value;
            }
            case "int": 
            case "Integer": {
                return Integer.parseInt(parameter.value);
            }
            case "long": 
            case "Long": {
                return Long.parseLong(parameter.value);
            }
            case "boolean": 
            case "Boolean": {
                return Boolean.parseBoolean(parameter.value);
            }
            case "double": 
            case "Double": {
                return Double.parseDouble(parameter.value);
            }
            case "short": 
            case "Short": {
                return Short.parseShort(parameter.value);
            }
            case "float": 
            case "Float": {
                return Float.valueOf(Float.parseFloat(parameter.value));
            }
            case "char": 
            case "Character": {
                return Character.valueOf(parameter.value.charAt(0));
            }
            case "byte": 
            case "Byte": {
                return Byte.parseByte(parameter.value);
            }
        }
        return null;
    }

    private List<String> parameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameterCount());
        for (PathSegment segment : this.matchable.pathSegments) {
            if (!segment.pathParameter) continue;
            parameterNames.add(segment.value);
        }
        return parameterNames;
    }

    public static class ToSpec {
        private final String methodName;
        private final List<MethodParameter> parameters;

        public final String methodName() {
            return this.methodName;
        }

        public final List<MethodParameter> parameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public String signature() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.methodName).append("(").append(this.commaSeparatedParameters()).append(")");
            return builder.toString();
        }

        public String toString() {
            return "ToSpec[methodName=" + this.methodName + ", parameters=" + this.parameters + "]";
        }

        ToSpec(String to) {
            Tuple2<String, List<MethodParameter>> parsed = this.parse(to);
            this.methodName = (String)parsed._1;
            this.parameters = (List)parsed._2;
        }

        MethodParameter body() {
            for (MethodParameter parameter : this.parameters) {
                if (!parameter.isBody()) continue;
                return parameter;
            }
            return null;
        }

        MethodParameter parameterOf(String name) {
            for (MethodParameter parameter : this.parameters) {
                if (!parameter.name.equals(name)) continue;
                return parameter;
            }
            return null;
        }

        private String commaSeparatedParameters() {
            StringBuilder builder = new StringBuilder();
            String separator = "";
            for (MethodParameter parameter : this.parameters) {
                builder.append(separator).append(parameter.type).append(" ").append(parameter.name);
                separator = ", ";
            }
            return builder.toString();
        }

        private Class<?> load(String classname) {
            try {
                return Class.forName(classname);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot load class for: " + classname);
            }
        }

        private Tuple2<String, List<MethodParameter>> parse(String to) {
            String bad = "Invalid to declaration: " + to;
            int openParen = to.indexOf("(");
            int closeParen = to.lastIndexOf(")");
            if (openParen < 0 || closeParen < 0) {
                throw new IllegalStateException(bad);
            }
            String methodName = to.substring(0, openParen);
            String[] rawParameters = to.substring(openParen + 1, closeParen).split(",");
            ArrayList<MethodParameter> parameters = new ArrayList<MethodParameter>(rawParameters.length);
            for (String rawParameter : rawParameters) {
                if ((rawParameter = rawParameter.trim()).isEmpty()) continue;
                if (rawParameter.startsWith("body:")) {
                    String[] body = this.typeAndName(rawParameter.substring(5));
                    parameters.add(new MethodParameter(body[0], body[1], this.load(this.qualifiedType(body[0]))));
                    continue;
                }
                String[] other = this.typeAndName(rawParameter);
                parameters.add(new MethodParameter(other[0], other[1]));
            }
            return Tuple2.from((Object)methodName, parameters);
        }

        private String qualifiedType(String possiblyUnqualifiedType) {
            switch (possiblyUnqualifiedType) {
                case "String": {
                    return "java.lang.String";
                }
                case "int": 
                case "Integer": {
                    return "java.lang.Integer";
                }
                case "long": 
                case "Long": {
                    return "java.lang.Long";
                }
                case "boolean": 
                case "Boolean": {
                    return "java.lang.Boolean";
                }
                case "double": 
                case "Double": {
                    return "java.lang.Double";
                }
                case "short": 
                case "Short": {
                    return "java.lang.Short";
                }
                case "float": 
                case "Float": {
                    return "java.lang.Float";
                }
                case "char": 
                case "Character": {
                    return "java.lang.Character";
                }
                case "byte": 
                case "Byte": {
                    return "java.lang.Byte";
                }
            }
            return possiblyUnqualifiedType;
        }

        private String[] typeAndName(String rawParameter) {
            int space = rawParameter.lastIndexOf(32);
            if (space == -1) {
                throw new IllegalStateException("Parameter mimeType and name must be separated by space: " + rawParameter);
            }
            String[] type_name = new String[]{rawParameter.substring(0, space).trim(), rawParameter.substring(space + 1).trim()};
            return type_name;
        }
    }

    private static class PathSegment {
        private final boolean pathParameter;
        private final String value;

        public String toString() {
            return "PathSegment[pathParameter=" + this.pathParameter + ", value=" + this.value + "]";
        }

        PathSegment(String value, boolean pathParameter) {
            this.value = value;
            this.pathParameter = pathParameter;
        }

        public int lastIndexOf(int startIndex) {
            return startIndex + this.value.length();
        }

        boolean isPathParameter() {
            return this.pathParameter;
        }
    }

    private static class Matchable {
        private final List<PathSegment> pathSegments;

        public int hashCode() {
            return 31 * this.pathSegments.hashCode();
        }

        public String toString() {
            return "Matchable[pathSegments=" + this.pathSegments + "]";
        }

        Matchable(String uri) {
            this.pathSegments = this.segmented(uri);
        }

        PathSegment pathSegment(int index) {
            return this.pathSegments.get(index);
        }

        int totalSegments() {
            return this.pathSegments.size();
        }

        private List<PathSegment> segmented(String uri) {
            ArrayList<PathSegment> segments;
            block2: {
                int openBrace;
                segments = new ArrayList<PathSegment>();
                String start = uri;
                while ((openBrace = start.indexOf("{")) >= 0) {
                    int closeBrace = start.indexOf("}", openBrace);
                    if (closeBrace > openBrace) {
                        String segment = start.substring(0, openBrace);
                        segments.add(new PathSegment(segment, false));
                        String parameter = start.substring(openBrace + 1, closeBrace);
                        segments.add(new PathSegment(parameter, true));
                        if (!(start = start.substring(closeBrace + 1)).isEmpty()) continue;
                        break block2;
                    }
                    throw new IllegalStateException("URI has unbalanced brace: " + uri);
                }
                segments.add(new PathSegment(start, false));
            }
            return segments;
        }
    }

    private static class MatchSegment {
        private final boolean pathParameter;
        private final int pathStartIndex;

        public String toString() {
            return "MatchSegment[pathParameter=" + this.pathParameter + ", pathStartIndex=" + this.pathStartIndex + "]";
        }

        MatchSegment(boolean pathParameter, int pathStartIndex) {
            this.pathParameter = pathParameter;
            this.pathStartIndex = pathStartIndex;
        }

        int pathStartIndex() {
            return this.pathStartIndex;
        }

        boolean isPathParameter() {
            return this.pathParameter;
        }
    }

    private static class RunningMatchSegments {
        private final List<MatchSegment> matchSegments;

        public String toString() {
            return "RunningMatchSegments[matchSegments=" + this.matchSegments + "]";
        }

        RunningMatchSegments(int totalSegments) {
            this.matchSegments = new ArrayList<MatchSegment>(totalSegments + 1);
        }

        void keepParameterSegment(int pathStartIndex) {
            this.matchSegments.add(new MatchSegment(true, pathStartIndex));
        }

        void keepPathSegment(int pathStartIndex, int pathEndIndex) {
            this.matchSegments.add(new MatchSegment(false, pathStartIndex));
        }

        int nextSegmentStartIndex(int index, int maxIndex) {
            return index < this.total() - 1 ? this.matchSegment(index + 1).pathStartIndex : maxIndex;
        }

        MatchSegment matchSegment(int index) {
            return this.matchSegments.get(index);
        }

        int total() {
            return this.matchSegments.size();
        }
    }

    public static class MethodParameter {
        public final Class<?> bodyType;
        public final String name;
        public final String type;

        public MethodParameter(String type, String name) {
            this(type, name, null);
        }

        public MethodParameter(String type, String name, Class<?> bodyClass) {
            this.type = type;
            this.name = name;
            this.bodyType = bodyClass;
        }

        public boolean isBody() {
            return this.bodyType != null;
        }

        public String toString() {
            return "MethodParameter[mimeType=" + this.type + ", name=" + this.name + "]";
        }
    }

    public static class RawPathParameter {
        public final String name;
        public final String value;

        static RawPathParameter named(String name, List<RawPathParameter> parameters) {
            for (RawPathParameter param : parameters) {
                if (!param.name.equals(name)) continue;
                return param;
            }
            return null;
        }

        public RawPathParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "Parameter[name=" + this.name + ", value=" + this.value + "]";
        }
    }

    public static class BodyTypedParameter {
        public final String name;
        public final Class<?> type;

        public BodyTypedParameter(Class<?> type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return "BodyParameter[mimeType=" + this.type.getName() + ", name=" + this.name + "]";
        }
    }

    public static class MatchResults {
        public final Action action;
        public final boolean matched;
        private final List<RawPathParameter> parameters;

        public String toString() {
            return "MatchResults[action=" + this.action + ", matched=" + this.matched + ", parameters=" + this.parameters + "]";
        }

        MatchResults(Action action, RunningMatchSegments running, List<String> parameterNames, String path) {
            this.action = action;
            this.parameters = new ArrayList<RawPathParameter>(parameterNames.size());
            if (running == null) {
                this.matched = false;
            } else {
                int pathLength = 0;
                int total = running.total();
                int parameterIndex = 0;
                for (int idx = 0; idx < total; ++idx) {
                    MatchSegment segment = running.matchSegment(idx);
                    if (segment.isPathParameter()) {
                        int pathEndIndex;
                        int pathStartIndex = segment.pathStartIndex();
                        if (pathStartIndex >= (pathEndIndex = running.nextSegmentStartIndex(idx, path.length()))) {
                            this.matched = false;
                            return;
                        }
                        String value = path.substring(pathStartIndex, pathEndIndex);
                        if (value.indexOf("/") >= 0 && !"/".equals(path.substring(pathEndIndex - 1))) {
                            this.matched = false;
                            return;
                        }
                        pathLength += value.length();
                        this.parameters.add(new RawPathParameter(parameterNames.get(parameterIndex++), value));
                        continue;
                    }
                    pathLength += action.matchable.pathSegment(idx).value.length();
                }
                this.matched = pathLength == path.length();
            }
        }

        public boolean isMatched() {
            return this.matched;
        }

        public int parameterCount() {
            return this.parameters.size();
        }

        public List<RawPathParameter> parameters() {
            return this.parameters;
        }
    }

    public static class MappedParameter {
        public final String type;
        public final Object value;

        MappedParameter(String type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return "MappedParameter[mimeType=" + this.type + ", value=" + this.value + "]";
        }
    }

    public static class MappedParameters {
        public final int actionId;
        public final List<MappedParameter> mapped;
        public final Method httpMethod;
        public final String methodName;

        MappedParameters(int actionId, Method httpMethod, String methodName, List<MappedParameter> mapped) {
            this.actionId = actionId;
            this.httpMethod = httpMethod;
            this.methodName = methodName;
            this.mapped = mapped;
        }

        public String toString() {
            return "MappedParameters[actionId=" + this.actionId + ", httpMethod=" + (Object)((Object)this.httpMethod) + ", methodName=" + this.methodName + ", mapped=" + this.mapped + "]";
        }
    }
}

