/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.RouterSpecification;
import io.vlingo.actors.Stage;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduler;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.ClientConsumer;
import io.vlingo.http.resource.ClientConsumerWorkerActor;
import io.vlingo.http.resource.ClientCorrelatingRequesterConsumerActor;
import io.vlingo.http.resource.LoadBalancingClientRequestConsumerActor;
import io.vlingo.http.resource.ResponseConsumer;
import io.vlingo.http.resource.RoundRobinClientRequestConsumerActor;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Host;
import java.util.List;

public class Client {
    public static String ClientIdCustomHeader = "X-VLINGO-CLIENT-ID";
    private final Configuration configuration;
    private final ClientConsumer consumer;

    public static Client using(Configuration configuration, ClientConsumerType type, int poolSize) throws Exception {
        return new Client(configuration, type, poolSize);
    }

    public static Client using(Configuration configuration) throws Exception {
        return new Client(configuration);
    }

    public Client(Configuration configuration, ClientConsumerType type, int poolSize) throws Exception {
        Object instantiator;
        Class clientConsumerType;
        this.configuration = configuration;
        switch (type) {
            case Correlating: {
                clientConsumerType = ClientCorrelatingRequesterConsumerActor.class;
                instantiator = new ClientConsumer.CorrelatingClientConsumerInstantiator(configuration);
                break;
            }
            case RoundRobin: {
                clientConsumerType = RoundRobinClientRequestConsumerActor.class;
                Definition definition = Definition.has(ClientConsumerWorkerActor.class, (List)Definition.parameters((Object[])new Object[]{configuration}));
                RouterSpecification spec = new RouterSpecification(poolSize, definition, ClientConsumer.class);
                instantiator = new ClientConsumer.RoundRobinClientRequestConsumerInstantiator(configuration, (RouterSpecification<ClientConsumer>)spec);
                break;
            }
            case LoadBalancing: {
                clientConsumerType = LoadBalancingClientRequestConsumerActor.class;
                Definition definition = Definition.has(ClientConsumerWorkerActor.class, (List)Definition.parameters((Object[])new Object[]{configuration}));
                RouterSpecification spec = new RouterSpecification(poolSize, definition, ClientConsumer.class);
                instantiator = new ClientConsumer.LoadBalancingClientRequestConsumerInstantiator(configuration, (RouterSpecification<ClientConsumer>)spec);
                break;
            }
            default: {
                throw new IllegalArgumentException("ClientConsumerType is not mapped: " + (Object)((Object)type));
            }
        }
        this.consumer = (ClientConsumer)configuration.stage.actorFor(ClientConsumer.class, Definition.has(clientConsumerType, (ActorInstantiator)instantiator));
    }

    public Client(Configuration configuration) throws Exception {
        this(configuration, ClientConsumerType.Correlating, 0);
    }

    public void close() {
        this.consumer.stop();
    }

    public Completes<Response> requestWith(Request request) {
        Completes completes = this.configuration.keepAlive ? Completes.repeatableUsing((Scheduler)this.configuration.stage.scheduler()) : Completes.using((Scheduler)this.configuration.stage.scheduler());
        request.headers.and("Connection", this.configuration.keepAlive ? "keep-alive" : "close");
        this.consumer.requestWith(request, (Completes<Response>)completes);
        return completes;
    }

    public static class Configuration {
        public final Address addressOfHost;
        public final ResponseConsumer consumerOfUnknownResponses;
        public final boolean keepAlive;
        public final long probeInterval;
        public final int readBufferSize;
        public final int readBufferPoolSize;
        public final int writeBufferSize;
        public final Stage stage;
        public final boolean secure;
        public Object testInfo = null;

        public static Configuration defaultedExceptFor(Stage stage, ResponseConsumer consumerOfUnknownResponses) {
            return Configuration.defaultedExceptFor(stage, Address.from((Host)Host.of((String)"localhost"), (int)8080, (AddressType)AddressType.NONE), consumerOfUnknownResponses);
        }

        public static Configuration defaultedExceptFor(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses) {
            return Configuration.has(stage, addressOfHost, consumerOfUnknownResponses, false, 10L, 10240, 10, 10240);
        }

        public static Configuration defaultedExceptFor(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses, int writeBufferSize, int readBufferSize) {
            return Configuration.has(stage, addressOfHost, consumerOfUnknownResponses, false, 10L, writeBufferSize, 10, readBufferSize);
        }

        public static Configuration defaultedKeepAliveExceptFor(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses) {
            return Configuration.has(stage, addressOfHost, consumerOfUnknownResponses, true, 10L, 10240, 10, 10240);
        }

        public static Configuration has(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses, boolean keepAlive, long probeInterval, int writeBufferSize, int readBufferPoolSize, int readBufferSize) {
            return new Configuration(stage, addressOfHost, consumerOfUnknownResponses, keepAlive, probeInterval, writeBufferSize, readBufferPoolSize, readBufferSize, false);
        }

        public static Configuration secure(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses, boolean keepAlive, long probeInterval, int writeBufferSize, int readBufferPoolSize, int readBufferSize) {
            return new Configuration(stage, addressOfHost, consumerOfUnknownResponses, keepAlive, probeInterval, writeBufferSize, readBufferPoolSize, readBufferSize, true);
        }

        public Configuration(Stage stage, Address addressOfHost, ResponseConsumer consumerOfUnknownResponses, boolean keepAlive, long probeInterval, int writeBufferSize, int readBufferPoolSize, int readBufferSize, boolean secure) {
            this.stage = stage;
            this.addressOfHost = addressOfHost;
            this.consumerOfUnknownResponses = consumerOfUnknownResponses;
            this.keepAlive = keepAlive;
            this.probeInterval = probeInterval;
            this.writeBufferSize = writeBufferSize;
            this.readBufferPoolSize = readBufferPoolSize;
            this.readBufferSize = readBufferSize;
            this.secure = secure;
        }

        public boolean hasTestInfo() {
            return this.testInfo != null;
        }

        public <R> R testInfo() {
            return (R)this.testInfo;
        }

        public void testInfo(Object testInfo) {
            this.testInfo = testInfo;
        }
    }

    public static enum ClientConsumerType {
        Correlating,
        LoadBalancing,
        RoundRobin;

    }
}

