/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Returns;
import io.vlingo.common.Completes;
import io.vlingo.http.Request;
import io.vlingo.http.RequestHeader;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.ResponseParser;
import io.vlingo.http.resource.Client;
import io.vlingo.http.resource.ClientConsumer;
import io.vlingo.http.resource.RequestSender;
import io.vlingo.http.resource.RequestSenderProbeActor;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.message.ConsumerByteBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConsumerWorkerActor
extends Actor
implements ClientConsumer {
    private static final String EmptyTestId = "";
    private static final AtomicInteger testIdGenerator = new AtomicInteger(0);
    private final String testId;
    private CompletesEventually completesEventually;
    private ResponseParser parser;
    private final RequestSender requestSender;

    public ClientConsumerWorkerActor(Client.Configuration configuration) throws Exception {
        this.testId = configuration.hasTestInfo() ? Integer.toString(testIdGenerator.incrementAndGet()) : EmptyTestId;
        this.requestSender = this.startRequestSender(configuration);
        this.parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(ConsumerByteBuffer buffer) {
        try {
            ByteBuffer parsable = buffer.asByteBuffer();
            if (!parsable.hasRemaining()) {
                this.logger().debug("CONSUMER: NO CONTENT");
                return;
            }
            this.logger().debug("CONSUMER:\n" + new String(parsable.array(), 0, parsable.remaining()));
            if (this.parser == null) {
                this.parser = ResponseParser.parserFor(parsable);
            } else {
                this.parser.parseNext(parsable);
            }
            if (this.parser.hasFullResponse()) {
                Response response = this.parser.fullResponse();
                if (this.testId != EmptyTestId) {
                    response.headers.add(ResponseHeader.of(Client.ClientIdCustomHeader, this.testId));
                    this.logger().debug("Client Worker: " + this.testId + " Consuming");
                    this.logger().debug("Client Worker: " + this.testId + "\nConsuming:\n" + response);
                }
                this.completesEventually.with((Object)response);
                this.completesEventually = null;
                this.disperseStowedMessages();
            }
            if (!this.parser.isMissingContent()) {
                this.parser = null;
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public Completes<Response> requestWith(Request request, Completes<Response> completes) {
        this.completesEventually = this.stage().world().completesFor(Returns.value(completes));
        if (this.testId != EmptyTestId) {
            request.headers.add(RequestHeader.of(Client.ClientIdCustomHeader, this.testId));
            request.headers.add(RequestHeader.of("X-Correlation-ID", this.testId));
            this.logger().debug("Client Worker: " + this.testId + " Requesting");
            this.logger().debug("Client Worker: " + this.testId + "\nRequesting:\n" + request);
        }
        this.requestSender.sendRequest(request);
        this.stowMessages(new Class[]{ResponseChannelConsumer.class});
        return completes;
    }

    public void stop() {
        this.requestSender.stop();
        super.stop();
    }

    private RequestSender startRequestSender(Client.Configuration configuration) throws Exception {
        ResponseChannelConsumer self = (ResponseChannelConsumer)this.selfAs(ResponseChannelConsumer.class);
        Definition definition = Definition.has(RequestSenderProbeActor.class, (ActorInstantiator)new RequestSender.RequestSenderProbeInstantiator(configuration, self, this.testId));
        RequestSender requestSender = (RequestSender)this.childActorFor(RequestSender.class, definition);
        return requestSender;
    }
}

