/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Actor;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Returns;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduled;
import io.vlingo.http.Request;
import io.vlingo.http.RequestHeader;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.ResponseParser;
import io.vlingo.http.resource.Client;
import io.vlingo.http.resource.ClientConsumer;
import io.vlingo.http.resource.ClientConsumerCommons;
import io.vlingo.wire.channel.ResponseChannelConsumer;
import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.Converters;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ClientCorrelatingRequesterConsumerActor
extends Actor
implements ClientConsumer {
    private final Map<String, CompletesEventually> completables;
    private final ClientConsumer.State state;

    public ClientCorrelatingRequesterConsumerActor(Client.Configuration configuration) throws Exception {
        this.state = new ClientConsumer.State(configuration, ClientConsumerCommons.clientChannel(configuration, (ResponseChannelConsumer)this.selfAs(ResponseChannelConsumer.class), this.logger()), null, this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1L, configuration.probeInterval), ByteBufferAllocator.allocate((int)configuration.writeBufferSize));
        this.completables = new HashMap<String, CompletesEventually>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(ConsumerByteBuffer buffer) {
        try {
            if (this.state.parser == null) {
                this.state.parser = ResponseParser.parserFor(buffer.asByteBuffer());
            } else {
                this.state.parser.parseNext(buffer.asByteBuffer());
            }
            while (this.state.parser.hasFullResponse()) {
                CompletesEventually completes;
                Response response = this.state.parser.fullResponse();
                ResponseHeader correlationId = response.headers.headerOfOrDefault("X-Correlation-ID", this.state.correlationId);
                if (correlationId == null) {
                    this.logger().warn("Client Consumer: Cannot complete response because no correlation id.");
                    this.state.configuration.consumerOfUnknownResponses.consume(response);
                    continue;
                }
                if (this.state.parser.isKeepAliveConnection() && this.state.parser.isStreamContentType()) {
                    this.state.correlationId = correlationId;
                }
                CompletesEventually completesEventually = completes = this.state.configuration.keepAlive ? this.completables.get(correlationId.value) : this.completables.remove(correlationId.value);
                if (completes == null) {
                    this.state.configuration.stage.world().defaultLogger().warn("Client Consumer: Cannot complete response because mismatched correlation id: " + correlationId.value);
                    this.state.configuration.consumerOfUnknownResponses.consume(response);
                    continue;
                }
                completes.with((Object)response);
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.state.channel.probeChannel();
    }

    @Override
    public Completes<Response> requestWith(Request request, Completes<Response> completes) {
        Request readyRequest;
        RequestHeader correlationId = request.headers.headerOf("X-Correlation-ID");
        if (correlationId == null) {
            correlationId = RequestHeader.of("X-Correlation-ID", UUID.randomUUID().toString());
            readyRequest = request.and(correlationId);
        } else {
            readyRequest = request;
        }
        this.completables.put(correlationId.value, this.stage().world().completesFor(Returns.value(completes)));
        this.state.buffer.clear();
        this.state.buffer.put(Converters.textToBytes((String)readyRequest.toString()));
        this.state.buffer.flip();
        this.state.channel.requestWith(this.state.buffer);
        return completes;
    }

    public void stop() {
        this.state.channel.close();
        this.state.probe.cancel();
    }
}

