/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import java.util.Properties;

public class Configuration {
    public static Configuration instance;
    private int port = 8080;
    private Sizing sizing = Sizing.define();
    private Timing timing = new Timing(4L, 2L, 100L);

    public static Configuration define() {
        instance = new Configuration();
        return instance;
    }

    public static Configuration defineWith(Properties properties) {
        instance = new Configuration(properties);
        return instance;
    }

    public Configuration withPort(int port) {
        this.port = port;
        return this;
    }

    public Configuration with(Sizing sizing) {
        this.sizing = sizing;
        return this;
    }

    public Configuration with(Timing timing) {
        this.timing = timing;
        return this;
    }

    public int port() {
        return this.port;
    }

    public Sizing sizing() {
        return this.sizing;
    }

    public Timing timing() {
        return this.timing;
    }

    private Configuration() {
    }

    private Configuration(Properties properties) {
        this();
        this.port = Integer.parseInt(properties.getProperty("server.http.port", String.valueOf(this.port)));
        int processorPoolSize = Integer.parseInt(properties.getProperty("server.processor.pool.size", String.valueOf(this.sizing.processorPoolSize)));
        int dispatcherPoolSize = Integer.parseInt(properties.getProperty("server.dispatcher.pool", String.valueOf(this.sizing.dispatcherPoolSize)));
        int maxBufferPoolSize = Integer.parseInt(properties.getProperty("server.buffer.pool.size", String.valueOf(this.sizing.maxBufferPoolSize)));
        int maxMessageSize = Integer.parseInt(properties.getProperty("server.message.buffer.size", String.valueOf(this.sizing.maxMessageSize)));
        long probeInterval = Long.parseLong(properties.getProperty("server.probe.interval", String.valueOf(this.timing.probeInterval)));
        long probeTimeout = Long.parseLong(properties.getProperty("server.probe.timeout", String.valueOf(this.timing.probeInterval)));
        long requestMissingContentTimeout = Long.parseLong(properties.getProperty("server.request.missing.content.timeout", String.valueOf(this.timing.requestMissingContentTimeout)));
        this.sizing = new Sizing(processorPoolSize, dispatcherPoolSize, maxBufferPoolSize, maxMessageSize);
        this.timing = new Timing(probeInterval, probeTimeout, requestMissingContentTimeout);
    }

    public static class Timing {
        public final long probeInterval;
        public final long probeTimeout;
        public final long requestMissingContentTimeout;

        public Timing(long probeInterval, long probeTimeout, long requestMissingContentTimeout) {
            this.probeInterval = probeInterval;
            this.probeTimeout = probeTimeout;
            this.requestMissingContentTimeout = requestMissingContentTimeout;
        }

        public static Timing define() {
            return new Timing(7L, 3L, 100L);
        }

        public static Timing defineWith(long probeInterval, long probeTimeout, long requestMissingContentTimeout) {
            return new Timing(probeInterval, probeTimeout, requestMissingContentTimeout);
        }

        public Timing withProbeInterval(int probeInterval) {
            return new Timing(probeInterval, this.probeTimeout, this.requestMissingContentTimeout);
        }

        public Timing withProbeTimeout(int probeTimeout) {
            return new Timing(this.probeInterval, probeTimeout, this.requestMissingContentTimeout);
        }

        public Timing withRequestMissingContentTimeout(long requestMissingContentTimeout) {
            return new Timing(this.probeInterval, this.probeTimeout, requestMissingContentTimeout);
        }
    }

    public static class Sizing {
        public final int processorPoolSize;
        public final int dispatcherPoolSize;
        public final int maxBufferPoolSize;
        public final int maxMessageSize;

        public Sizing(int processorPoolSize, int dispatcherPoolSize, int maxBufferPoolSize, int maxMessageSize) {
            this.processorPoolSize = processorPoolSize;
            this.dispatcherPoolSize = dispatcherPoolSize;
            this.maxBufferPoolSize = maxBufferPoolSize;
            this.maxMessageSize = maxMessageSize;
        }

        public static Sizing define() {
            return new Sizing(10, 10, 100, 65535);
        }

        public static Sizing defineWith(int processorPoolSize, int dispatcherPoolSize, int maxBufferPoolSize, int maxMessageSize) {
            return new Sizing(processorPoolSize, dispatcherPoolSize, maxBufferPoolSize, maxMessageSize);
        }

        public Sizing withProcessorPoolSize(int processorPoolSize) {
            return new Sizing(processorPoolSize, this.dispatcherPoolSize, this.maxBufferPoolSize, this.maxMessageSize);
        }

        public Sizing withDispatcherPoolSize(int dispatcherPoolSize) {
            return new Sizing(this.processorPoolSize, dispatcherPoolSize, this.maxBufferPoolSize, this.maxMessageSize);
        }

        public Sizing withMaxBufferPoolSize(int maxBufferPoolSize) {
            return new Sizing(this.processorPoolSize, this.dispatcherPoolSize, maxBufferPoolSize, this.maxMessageSize);
        }

        public Sizing withMaxMessageSize(int maxMessageSize) {
            return new Sizing(this.processorPoolSize, this.dispatcherPoolSize, this.maxBufferPoolSize, maxMessageSize);
        }
    }
}

