/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.common.compiler.DynaClassLoader;
import io.vlingo.common.compiler.DynaCompiler;
import io.vlingo.http.Method;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.Resource;
import io.vlingo.http.resource.ResourceDispatcherGenerator;
import io.vlingo.http.resource.ResourceHandler;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public abstract class ConfigurationResource<T>
extends Resource<T> {
    static final String DispatcherSuffix = "Dispatcher";
    private static DynaClassLoader classLoader = new DynaClassLoader(ConfigurationResource.class.getClassLoader());
    private static final DynaCompiler dynaCompiler = new DynaCompiler();
    public final Class<? extends ResourceHandler> resourceHandlerClass;
    final List<Action> actions;

    public static ConfigurationResource<?> defining(String resourceName, Class<? extends ResourceHandler> resourceHandlerClass, int handlerPoolSize, List<Action> actions) {
        return ConfigurationResource.newResourceFor(resourceName, resourceHandlerClass, handlerPoolSize, actions);
    }

    static ConfigurationResource<?> newResourceFor(String resourceName, Class<? extends ResourceHandler> resourceHandlerClass, int handlerPoolSize, List<Action> actions) {
        ConfigurationResource.assertSaneActions(actions);
        try {
            String targetClassname = resourceHandlerClass.getName() + DispatcherSuffix;
            Class<Object> resourceClass = null;
            try {
                resourceClass = Class.forName(targetClassname);
            }
            catch (Exception e) {
                resourceClass = ConfigurationResource.tryGenerateCompile(resourceHandlerClass, targetClassname, actions);
            }
            Object[] ctorParams = new Object[]{resourceName, resourceHandlerClass, handlerPoolSize, actions};
            for (Constructor<?> ctor : resourceClass.getConstructors()) {
                if (ctor.getParameterCount() != ctorParams.length) continue;
                ConfigurationResource resourceDispatcher = (ConfigurationResource)ctor.newInstance(ctorParams);
                return resourceDispatcher;
            }
            return (ConfigurationResource)resourceClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create a resource from resource handler " + resourceHandlerClass.getName() + " because: " + e.getMessage());
        }
    }

    static Class<? extends ResourceHandler> newResourceHandlerClassFor(String resourceHandlerClassname) {
        try {
            Class<?> resourceHandlerClass = Class.forName(resourceHandlerClassname);
            ConfigurationResource.confirmResourceHandler(resourceHandlerClass);
            return resourceHandlerClass;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The resource handler class " + resourceHandlerClassname + " cannot be loaded because: " + e.getMessage());
        }
    }

    private static void assertSaneActions(List<Action> actions) {
        int expectedId = 0;
        for (Action action : actions) {
            if (action.id != expectedId) {
                throw new IllegalArgumentException("Action id in conflict with expected ordering: expected id: " + expectedId + " Action is: " + action);
            }
            ++expectedId;
        }
    }

    private static void confirmResourceHandler(Class<?> resourceHandlerClass) {
        for (Class<?> superclass = resourceHandlerClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (superclass != ResourceHandler.class) continue;
            return;
        }
        throw new IllegalStateException("ConfigurationResource handler class must extends ResourceHandler: " + resourceHandlerClass.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<ConfigurationResource<?>> tryGenerateCompile(Class<? extends ResourceHandler> resourceHandlerClass, String targetClassname, List<Action> actions) {
        try (ResourceDispatcherGenerator generator = ResourceDispatcherGenerator.forMain(actions, true);){
            Class<ConfigurationResource<?>> throwable3 = ConfigurationResource.tryGenerateCompile(resourceHandlerClass, generator, targetClassname);
            return throwable3;
        }
        catch (Exception emain) {
            try (ResourceDispatcherGenerator generator2 = ResourceDispatcherGenerator.forTest(actions, true);){
                Class<ConfigurationResource<?>> clazz = ConfigurationResource.tryGenerateCompile(resourceHandlerClass, generator2, targetClassname);
                return clazz;
            }
            catch (Exception etest) {
                etest.printStackTrace();
                throw new IllegalArgumentException("ConfigurationResource dispatcher for " + resourceHandlerClass.getName() + " not created for main or test because: " + etest.getMessage(), etest);
            }
        }
    }

    private static Class<ConfigurationResource<?>> tryGenerateCompile(Class<? extends ResourceHandler> resourceHandlerClass, ResourceDispatcherGenerator generator, String targetClassname) {
        try {
            ResourceDispatcherGenerator.Result result = generator.generateFor(resourceHandlerClass.getName());
            DynaCompiler.Input input = new DynaCompiler.Input(resourceHandlerClass, targetClassname, result.source, result.sourceFile, classLoader, generator.type(), true);
            Class resourceDispatcherClass = dynaCompiler.compile(input);
            return resourceDispatcherClass;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ConfigurationResource instance with dispatcher for " + resourceHandlerClass.getName() + " not created because: " + e.getMessage(), e);
        }
    }

    @Override
    Action.MatchResults matchWith(Method method, URI uri) {
        for (Action action : this.actions) {
            Action.MatchResults matchResults = action.matchWith(method, uri);
            if (!matchResults.isMatched()) continue;
            return matchResults;
        }
        return Action.unmatchedResults;
    }

    protected ConfigurationResource(String name, Class<? extends ResourceHandler> resourceHandlerClass, int handlerPoolSize, List<Action> actions) {
        super(name, handlerPoolSize);
        this.resourceHandlerClass = resourceHandlerClass;
        this.actions = Collections.unmodifiableList(actions);
    }

    @Override
    protected void log(Logger logger) {
        logger.info("Resource: " + this.name);
        for (Action action : this.actions) {
            logger.info("Action: id=" + action.id + ", method=" + (Object)((Object)action.method) + ", uri=" + action.uri + ", to=" + action.to.signature());
        }
    }

    @Override
    protected ResourceHandler resourceHandlerInstance(Stage stage) {
        try {
            for (Constructor<?> ctor : this.resourceHandlerClass.getConstructors()) {
                if (ctor.getParameterCount() != 1) continue;
                return (ResourceHandler)ctor.newInstance(stage.world());
            }
            return this.resourceHandlerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The instance for resource handler '" + this.resourceHandlerClass.getName() + "' cannot be created.");
        }
    }
}

