/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.http.Context;
import io.vlingo.http.Method;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.Resource;
import io.vlingo.http.resource.ResourceHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DynamicResource
extends Resource<ResourceHandler> {
    final List<RequestHandler> handlers;
    private final List<Action> actions = new ArrayList<Action>();

    protected DynamicResource(String name, int handlerPoolSize, List<RequestHandler> unsortedHandlers) {
        super(name, handlerPoolSize);
        this.handlers = this.sortHandlersBySlashes(unsortedHandlers);
        int currentId = 0;
        for (RequestHandler predicate : this.handlers) {
            this.actions.add(new Action(currentId++, predicate.method.toString(), predicate.path, "dynamic" + currentId + "(" + predicate.actionSignature + ")", null));
        }
    }

    @Override
    public void dispatchToHandlerWith(Context context, Action.MappedParameters mappedParameters) {
        try {
            RequestHandler handler = this.handlers.get(mappedParameters.actionId);
            this.pooledHandler().handleFor(context, mappedParameters, handler);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Action mismatch: Request: " + context.request + "Parameters: " + mappedParameters);
        }
    }

    @Override
    Action.MatchResults matchWith(Method method, URI uri) {
        for (Action action : this.actions) {
            Action.MatchResults matchResults = action.matchWith(method, uri);
            if (!matchResults.isMatched()) continue;
            return matchResults;
        }
        return Action.unmatchedResults;
    }

    @Override
    protected void log(Logger logger) {
        logger.info("Resource: " + this.name);
        for (Action action : this.actions) {
            logger.info("Action: id=" + action.id + ", method=" + (Object)((Object)action.method) + ", uri=" + action.uri + ", to=" + action.to.signature());
        }
    }

    @Override
    protected ResourceHandler resourceHandlerInstance(Stage stage) {
        return new PooledDynamicResourceHandler(stage, this);
    }

    private List<RequestHandler> sortHandlersBySlashes(List<RequestHandler> unsortedHandlers) {
        return unsortedHandlers.stream().sorted((handler1, handler2) -> {
            Long handler2Slashes;
            Long handler1Slashes = handler1.path.chars().filter(ch -> ch == 47).count();
            if (handler1Slashes.equals(handler2Slashes = Long.valueOf(handler2.path.chars().filter(ch -> ch == 47).count()))) {
                return 0;
            }
            return handler1Slashes < handler2Slashes ? 1 : -1;
        }).collect(Collectors.toList());
    }

    private static class PooledDynamicResourceHandler
    extends ResourceHandler {
        private final DynamicResource resource;

        PooledDynamicResourceHandler(Stage stage, DynamicResource resource) {
            this.stage = stage;
            this.resource = resource;
        }
    }
}

