/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.ActorFactory;
import io.vlingo.http.Method;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ConfigurationResource;
import io.vlingo.http.resource.ResourceHandler;
import io.vlingo.http.resource.Resources;
import io.vlingo.http.resource.StaticFilesResource;
import io.vlingo.http.resource.feed.FeedProducer;
import io.vlingo.http.resource.feed.FeedResource;
import io.vlingo.http.resource.sse.SseFeed;
import io.vlingo.http.resource.sse.SseStreamResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Loader {
    private static final String feedProducerNamePrefix = "feed.resource.name.";
    private static final String feedNamePathParameter = "{feedName}";
    private static final String feedProductIdPathParameter = "{feedProductId}";
    private static final String feedProducerClassnameParameter = "Class<? extends Actor> feedProducerClass";
    private static final String feedProducerProductElementsParameter = "int feedProductElements";
    private static final String feedProducerFeed = "feed(String feedName, String feedProductId, Class<? extends Actor> feedProducerClass, int feedProductElements)";
    private static final String resourceNamePrefix = "resource.name.";
    private static final String ssePublisherFeedClassnameParameter = "Class<? extends Actor> feedClass";
    private static final String ssePublisherFeedDefaultId = "String feedDefaultId";
    private static final String ssePublisherFeedIntervalParameter = "int feedInterval";
    private static final String ssePublisherFeedPayloadParameter = "int feedPayload";
    private static final String ssePublisherIdPathParameter = "{id}";
    private static final String ssePublisherNamePrefix = "sse.stream.name.";
    private static final String ssePublisherNamePathParameter = "{streamName}";
    private static final String ssePublisherSubscribeTo = "subscribeToStream(String streamName, Class<? extends Actor> feedClass, int feedPayload, int feedInterval, String feedDefaultId)";
    private static final String ssePublisherUnsubscribeTo = "unsubscribeFromStream(String streamName, String id)";
    private static final String staticFilesResource = "static.files";
    private static final String staticFilesResourcePool = "static.files.resource.pool";
    private static final String staticFilesResourceRoot = "static.files.resource.root";
    private static final String staticFilesResourceSubPaths = "static.files.resource.subpaths";
    private static final String staticFilesResourceServeFile = "serveFile(String contentFile, String root, String validSubPaths)";
    private static final String staticFilesResourcePathParameter = "{contentFile}";

    public static Resources loadResources(Properties properties) {
        HashMap namedResources = new HashMap();
        for (String resource : Loader.findResources(properties, resourceNamePrefix)) {
            ConfigurationResource<?> loaded = Loader.loadResource(properties, resource);
            namedResources.put(loaded.name, loaded);
        }
        namedResources.putAll(Loader.loadSseResources(properties));
        namedResources.putAll(Loader.loadFeedResources(properties));
        namedResources.putAll(Loader.loadStaticFilesResource(properties));
        return new Resources(namedResources);
    }

    private static Set<String> findResources(Properties properties, String namePrefix) {
        HashSet<String> resource = new HashSet<String>();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            resource.add(key);
        }
        return resource;
    }

    private static ConfigurationResource<?> loadResource(Properties properties, String resourceNameKey) {
        String resourceName = resourceNameKey.substring(resourceNamePrefix.length());
        String[] resourceActionNames = Loader.actionNamesFrom(properties.getProperty(resourceNameKey), resourceNameKey);
        String resourceHandlerKey = "resource." + resourceName + ".handler";
        String resourceHandlerClassname = properties.getProperty(resourceHandlerKey);
        String handlerPoolKey = "resource." + resourceName + ".pool";
        int maybeHandlerPoolSize = Integer.parseInt(properties.getProperty(handlerPoolKey, "1"));
        int handlerPoolSize = maybeHandlerPoolSize <= 0 ? 1 : maybeHandlerPoolSize;
        String disallowPathParametersWithSlashKey = "resource." + resourceName + ".disallowPathParametersWithSlash";
        boolean disallowPathParametersWithSlash = Boolean.parseBoolean(properties.getProperty(disallowPathParametersWithSlashKey, "true"));
        try {
            List<Action> resourceActions = Loader.resourceActionsOf(properties, resourceName, resourceActionNames, disallowPathParametersWithSlash);
            Class<ResourceHandler> resourceHandlerClass = ConfigurationResource.newResourceHandlerClassFor(resourceHandlerClassname);
            return Loader.resourceFor(resourceName, resourceHandlerClass, handlerPoolSize, resourceActions);
        }
        catch (Exception e) {
            System.out.println("vlingo/http: Failed to load resource: " + resourceName + " because: " + e.getMessage());
            throw e;
        }
    }

    private static Map<String, ConfigurationResource<?>> loadFeedResources(Properties properties) {
        HashMap feedResourceActions = new HashMap();
        for (String feedResourceName : Loader.findResources(properties, feedProducerNamePrefix)) {
            String feedURI = properties.getProperty(feedResourceName);
            String resourceName = feedResourceName.substring(feedProducerNamePrefix.length());
            String feedProducerClassnameKey = "feed.resource." + resourceName + ".producer.class";
            String feedProducerClassname = properties.getProperty(feedProducerClassnameKey);
            String feedElementsKey = "feed.resource." + resourceName + ".elements";
            int maybeFeedElements = Integer.parseInt(properties.getProperty(feedElementsKey, "20"));
            int feedElements = maybeFeedElements <= 0 ? 20 : maybeFeedElements;
            String poolKey = "feed.resource." + resourceName + ".pool";
            int maybePoolSize = Integer.parseInt(properties.getProperty(poolKey, "1"));
            int handlerPoolSize = maybePoolSize <= 0 ? 1 : maybePoolSize;
            String feedRequestURI = feedURI.replaceAll(resourceName, feedNamePathParameter) + "/" + feedProductIdPathParameter;
            try {
                Class feedClass = ActorFactory.actorClassWithProtocol((String)feedProducerClassname, FeedProducer.class);
                Action.MappedParameter mappedParameterProducerClass = new Action.MappedParameter("Class<? extends Actor>", feedClass);
                Action.MappedParameter mappedParameterProductElements = new Action.MappedParameter("int", feedElements);
                ArrayList<Action> actions = new ArrayList<Action>(1);
                List<Action.MappedParameter> additionalParameters = Arrays.asList(mappedParameterProducerClass, mappedParameterProductElements);
                actions.add(new Action(0, Method.GET.name, feedRequestURI, feedProducerFeed, null, additionalParameters));
                ConfigurationResource<?> resource = Loader.resourceFor(resourceName, FeedResource.class, handlerPoolSize, actions);
                feedResourceActions.put(resourceName, resource);
            }
            catch (Exception e) {
                String message = "vlingo/http: Failed to load feed resource: " + resourceName + " because: " + e.getMessage();
                System.out.println(message);
                e.printStackTrace();
                throw new IllegalArgumentException(message, e);
            }
        }
        return feedResourceActions;
    }

    private static Map<String, ConfigurationResource<?>> loadSseResources(Properties properties) {
        HashMap sseResourceActions = new HashMap();
        for (String streamResourceName : Loader.findResources(properties, ssePublisherNamePrefix)) {
            String streamURI = properties.getProperty(streamResourceName);
            String resourceName = streamResourceName.substring(ssePublisherNamePrefix.length());
            String feedClassnameKey = "sse.stream." + resourceName + ".feed.class";
            String feedClassname = properties.getProperty(feedClassnameKey);
            String feedPayloadKey = "sse.stream." + resourceName + ".feed.payload";
            int maybeFeedPayload = Integer.parseInt(properties.getProperty(feedPayloadKey, "20"));
            int feedPayload = maybeFeedPayload <= 0 ? 20 : maybeFeedPayload;
            String feedIntervalKey = "sse.stream." + resourceName + ".feed.interval";
            int maybeFeedInterval = Integer.parseInt(properties.getProperty(feedIntervalKey, "1000"));
            int feedInterval = maybeFeedInterval <= 0 ? 1000 : maybeFeedInterval;
            String feedDefaultIdKey = "sse.stream." + resourceName + ".feed.default.id";
            String feedDefaultId = properties.getProperty(feedDefaultIdKey, "");
            String poolKey = "sse.stream." + resourceName + ".pool";
            int maybePoolSize = Integer.parseInt(properties.getProperty(poolKey, "1"));
            int handlerPoolSize = maybePoolSize <= 0 ? 1 : maybePoolSize;
            String subscribeURI = streamURI.replaceAll(resourceName, ssePublisherNamePathParameter);
            String unsubscribeURI = subscribeURI + "/" + ssePublisherIdPathParameter;
            try {
                Class feedClass = ActorFactory.actorClassWithProtocol((String)feedClassname, SseFeed.class);
                Action.MappedParameter mappedParameterClass = new Action.MappedParameter("Class<? extends Actor>", feedClass);
                Action.MappedParameter mappedParameterPayload = new Action.MappedParameter("int", feedPayload);
                Action.MappedParameter mappedParameterInterval = new Action.MappedParameter("int", feedInterval);
                Action.MappedParameter mappedParameterDefaultId = new Action.MappedParameter("String", feedDefaultId);
                ArrayList<Action> actions = new ArrayList<Action>(2);
                List<Action.MappedParameter> additionalParameters = Arrays.asList(mappedParameterClass, mappedParameterPayload, mappedParameterInterval, mappedParameterDefaultId);
                actions.add(new Action(0, Method.GET.name, subscribeURI, ssePublisherSubscribeTo, null, additionalParameters));
                actions.add(new Action(1, Method.DELETE.name, unsubscribeURI, ssePublisherUnsubscribeTo, null));
                ConfigurationResource<?> resource = Loader.resourceFor(resourceName, SseStreamResource.class, handlerPoolSize, actions);
                sseResourceActions.put(resourceName, resource);
            }
            catch (Exception e) {
                System.out.println("vlingo/http: Failed to load SSE resource: " + streamResourceName + " because: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        return sseResourceActions;
    }

    private static Map<String, ConfigurationResource<?>> loadStaticFilesResource(Properties properties) {
        HashMap staticFilesResourceActions = new HashMap();
        String root = properties.getProperty(staticFilesResourceRoot);
        if (root == null) {
            return staticFilesResourceActions;
        }
        String poolSize = properties.getProperty(staticFilesResourcePool, "5");
        String validSubPaths = properties.getProperty(staticFilesResourceSubPaths);
        String[] actionSubPaths = Loader.actionNamesFrom(validSubPaths, staticFilesResourceSubPaths);
        Arrays.sort(actionSubPaths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                return path2.length() - path1.length();
            }
        });
        try {
            int resourceSequence = 0;
            for (String actionSubPath : actionSubPaths) {
                Action.MappedParameter mappedParameterRoot = new Action.MappedParameter("String", root);
                Action.MappedParameter mappedParameterValidSubPaths = new Action.MappedParameter("String", validSubPaths);
                String slash = actionSubPath.endsWith("/") ? "" : "/";
                String resourceName = staticFilesResource + resourceSequence++;
                ArrayList<Action> actions = new ArrayList<Action>(1);
                List<Action.MappedParameter> additionalParameters = Arrays.asList(mappedParameterRoot, mappedParameterValidSubPaths);
                actions.add(new Action(0, Method.GET.name, actionSubPath + slash + staticFilesResourcePathParameter, staticFilesResourceServeFile, null, additionalParameters));
                ConfigurationResource<?> resource = Loader.resourceFor(resourceName, StaticFilesResource.class, Integer.parseInt(poolSize), actions);
                staticFilesResourceActions.put(resourceName, resource);
            }
        }
        catch (Exception e) {
            System.out.println("vlingo/http: Failed to load static files resource: static.files because: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return staticFilesResourceActions;
    }

    private static ConfigurationResource<?> resourceFor(String resourceName, Class<? extends ResourceHandler> resourceHandlerClass, int handlerPoolSize, List<Action> resourceActions) {
        try {
            ConfigurationResource<?> resource = ConfigurationResource.newResourceFor(resourceName, resourceHandlerClass, handlerPoolSize, resourceActions);
            return resource;
        }
        catch (Exception e) {
            throw new IllegalStateException("ConfigurationResource cannot be created for: " + resourceHandlerClass.getName());
        }
    }

    private static String[] actionNamesFrom(String actionNamesProperty, String key) {
        int open = actionNamesProperty.indexOf("[");
        int close = actionNamesProperty.indexOf("]");
        if (open == -1 || close == -1) {
            throw new IllegalStateException("Cannot load action names for resource: " + key);
        }
        String[] actionNames = actionNamesProperty.substring(open + 1, close).trim().split(",\\s?");
        if (actionNames.length == 0) {
            throw new IllegalStateException("Cannot load action names for resource: " + key);
        }
        return actionNames;
    }

    private static List<Action> resourceActionsOf(Properties properties, String resourceName, String[] resourceActionNames, boolean disallowPathParametersWithSlash) {
        ArrayList<Action> resourceActions = new ArrayList<Action>(resourceActionNames.length);
        for (String actionName : resourceActionNames) {
            try {
                String keyPrefix = "action." + resourceName + "." + actionName + ".";
                int actionId = resourceActions.size();
                String method = properties.getProperty(keyPrefix + "method", null);
                String uri = properties.getProperty(keyPrefix + "uri", null);
                String to = properties.getProperty(keyPrefix + "to", null);
                String mapper = properties.getProperty(keyPrefix + "mapper", null);
                resourceActions.add(new Action(actionId, method, uri, to, mapper));
            }
            catch (Exception e) {
                System.out.println("vlingo/http: Failed to load resource: " + resourceName + " action:" + actionName + " because: " + e.getMessage());
                throw e;
            }
        }
        return resourceActions;
    }
}

