/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.http.media.ContentMediaType;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeNotSupportedException;
import java.util.HashMap;
import java.util.Map;

public class MediaTypeMapper {
    private final Map<ContentMediaType, Mapper> mappersByContentType;

    public MediaTypeMapper(Map<ContentMediaType, Mapper> mappersByContentType) {
        this.mappersByContentType = mappersByContentType;
    }

    public <T> T from(String data, ContentMediaType contentMediaType, Class<T> type) {
        ContentMediaType baseType = contentMediaType.toBaseType();
        if (this.mappersByContentType.containsKey(baseType)) {
            return this.mappersByContentType.get(baseType).from(data, type);
        }
        throw new MediaTypeNotSupportedException(contentMediaType.toString());
    }

    public <T> String from(T data, ContentMediaType contentMediaType) {
        ContentMediaType baseType = contentMediaType.toBaseType();
        if (this.mappersByContentType.containsKey(baseType)) {
            return this.mappersByContentType.get(baseType).from(data);
        }
        throw new MediaTypeNotSupportedException(contentMediaType.toString());
    }

    public ContentMediaType[] mappedMediaTypes() {
        return this.mappersByContentType.keySet().toArray(new ContentMediaType[0]);
    }

    public static class Builder {
        private Map<ContentMediaType, Mapper> mappersByContentType = new HashMap<ContentMediaType, Mapper>();

        Builder addMapperFor(ContentMediaType contentMediaType, Mapper mapper) {
            this.mappersByContentType.computeIfPresent(contentMediaType, (ct, mp) -> {
                throw new IllegalArgumentException("Content mimeType already added");
            });
            this.mappersByContentType.put(contentMediaType, mapper);
            return this;
        }

        MediaTypeMapper build() {
            return new MediaTypeMapper(this.mappersByContentType);
        }
    }
}

