/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.http.Body;
import io.vlingo.http.Header;
import io.vlingo.http.PlainBody;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.ResponseHeader;
import io.vlingo.http.Version;
import io.vlingo.http.media.ContentMediaType;
import io.vlingo.http.media.ResponseMediaTypeSelector;
import io.vlingo.http.resource.MediaTypeMapper;

public class ObjectResponse<T> {
    private static final ContentMediaType DEFAULT_MEDIA_TYPE = ContentMediaType.Json();
    private final Version version;
    private final Response.Status status;
    private final Header.Headers<ResponseHeader> headers;
    private T entity;

    private ObjectResponse(Version version, Response.Status status, Header.Headers<ResponseHeader> headers, T entity) {
        this.version = version;
        this.status = status;
        this.headers = headers;
        this.entity = entity;
    }

    public static <T> ObjectResponse<T> of(Version version, Response.Status status, Header.Headers<ResponseHeader> headers, T entity) {
        return new ObjectResponse<T>(version, status, headers, entity);
    }

    public static <T> ObjectResponse<T> of(Response.Status status, Header.Headers<ResponseHeader> headers, T entity) {
        return new ObjectResponse<T>(Version.Http1_1, status, headers, entity);
    }

    public static <T> ObjectResponse<T> of(Response.Status status, T entity) {
        return new ObjectResponse<T>(Version.Http1_1, status, Header.Headers.empty(), entity);
    }

    public Response responseFrom(Request request, MediaTypeMapper mapper) {
        String acceptedMediaTypes = request.headerValueOr("Accept", DEFAULT_MEDIA_TYPE.toString());
        ResponseMediaTypeSelector responseMediaTypeSelector = new ResponseMediaTypeSelector(acceptedMediaTypes);
        ContentMediaType responseContentMediaType = responseMediaTypeSelector.selectType(mapper.mappedMediaTypes());
        String bodyContent = mapper.from(this.entity, responseContentMediaType);
        PlainBody body = Body.from(bodyContent);
        this.headers.add(ResponseHeader.of("Content-Type", responseContentMediaType.toString()));
        return Response.of(this.version, this.status, this.headers, body);
    }
}

