/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.http.Header;
import io.vlingo.http.Request;
import io.vlingo.http.media.ContentMediaType;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.DefaultMediaTypeMapper;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import java.util.function.BiFunction;

class ParameterResolver<T> {
    public final Type type;
    public final Class<T> paramClass;
    private final BiFunction<Request, Action.MappedParameters, T> resolver;

    private ParameterResolver(Type type, Class<T> paramClass, BiFunction<Request, Action.MappedParameters, T> resolver) {
        this.type = type;
        this.paramClass = paramClass;
        this.resolver = resolver;
    }

    public static <T> ParameterResolver<T> path(int position, Class<T> paramClass) {
        return new ParameterResolver<Object>(Type.PATH, paramClass, (request, mappedParameters) -> {
            Object value = mappedParameters.mapped.get((int)position).value;
            if (paramClass.isInstance(value)) {
                return value;
            }
            throw new IllegalArgumentException("Value " + value + " is of mimeType " + mappedParameters.mapped.get((int)position).type + " instead of " + paramClass.getSimpleName());
        });
    }

    public static <T> ParameterResolver<T> body(Class<T> bodyClass) {
        return ParameterResolver.body(bodyClass, DefaultMediaTypeMapper.instance());
    }

    public static <T> ParameterResolver<T> body(Class<T> bodyClass, Mapper mapper) {
        return new ParameterResolver<Object>(Type.BODY, bodyClass, (request, mappedParameters) -> mapper.from(request.body.toString(), bodyClass));
    }

    public static <T> ParameterResolver<T> body(Class<T> bodyClass, MediaTypeMapper mediaTypeMapper) {
        return new ParameterResolver<Object>(Type.BODY, bodyClass, (request, mappedParameters) -> {
            String assumedBodyContentType = ContentMediaType.Json().toString();
            String bodyMediaType = request.headerValueOr("Content-Type", assumedBodyContentType);
            return mediaTypeMapper.from(request.body.toString(), ContentMediaType.parseFromDescriptor(bodyMediaType), bodyClass);
        });
    }

    public static ParameterResolver<Header> header(String headerName) {
        return new ParameterResolver<Header>(Type.HEADER, Header.class, (request, mappedParameters) -> request.headerOf(headerName));
    }

    public static ParameterResolver<String> query(String name) {
        return ParameterResolver.query(name, String.class, null);
    }

    public static <T> ParameterResolver<T> query(String name, Class<T> type) {
        return ParameterResolver.query(name, type, null);
    }

    public static <T> ParameterResolver<T> query(String name, Class<T> type, T defaultValue) {
        return new ParameterResolver<Object>(Type.QUERY, type, (request, mappedParameters) -> {
            String value;
            try {
                value = request.queryParameters().valuesOf(name).get(0);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return defaultValue;
            }
            if (type == Integer.class) {
                return type.cast(Integer.valueOf(value));
            }
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Float.class) {
                return type.cast(Float.valueOf(value));
            }
            if (type == Long.class) {
                return type.cast(Integer.valueOf(value));
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(value));
            }
            if (type == Short.class) {
                return type.cast(Short.valueOf(value));
            }
            if (type == Byte.class) {
                return type.cast(Byte.valueOf(value));
            }
            throw new IllegalArgumentException("unknown mimeType " + type.getSimpleName());
        });
    }

    public T apply(Request request, Action.MappedParameters mappedParameters) {
        return this.resolver.apply(request, mappedParameters);
    }

    static enum Type {
        PATH,
        BODY,
        HEADER,
        QUERY;

    }
}

