/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.DefaultErrorHandler;
import io.vlingo.http.resource.DefaultMediaTypeMapper;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.HandlerMissingException;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ParameterResolver;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RequestHandler {
    public final Method method;
    public final String path;
    public final String actionSignature;
    public final String contentSignature;
    public final Class<?> bodyType;
    private final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    protected MediaTypeMapper mediaTypeMapper;
    protected ErrorHandler errorHandler;

    protected RequestHandler(Method method, String path, List<ParameterResolver<?>> parameterResolvers) {
        this.method = method;
        this.path = path;
        this.actionSignature = this.generateActionSignature(parameterResolvers);
        this.contentSignature = this.detectRequestBodyType(parameterResolvers).map(Class::getSimpleName).orElse(null);
        this.bodyType = this.detectRequestBodyType(parameterResolvers).orElse(null);
        this.errorHandler = DefaultErrorHandler.instance();
        this.mediaTypeMapper = DefaultMediaTypeMapper.instance();
    }

    protected RequestHandler(Method method, String path, List<ParameterResolver<?>> parameterResolvers, ErrorHandler errorHandler, MediaTypeMapper mediaTypeMapper) {
        this.method = method;
        this.path = path;
        this.actionSignature = this.generateActionSignature(parameterResolvers);
        this.contentSignature = this.detectRequestBodyType(parameterResolvers).map(Class::getSimpleName).orElse(null);
        this.bodyType = this.detectRequestBodyType(parameterResolvers).orElse(null);
        this.errorHandler = errorHandler;
        this.mediaTypeMapper = mediaTypeMapper;
    }

    protected Completes<Response> runParamExecutor(Object paramExecutor, Supplier<Completes<Response>> executeRequest) {
        if (paramExecutor == null) {
            throw new HandlerMissingException("No handler defined for " + this.method.toString() + " " + this.path);
        }
        return executeRequest.get();
    }

    protected abstract Completes<Response> execute(Request var1, Action.MappedParameters var2, Logger var3);

    private Optional<? extends Class<?>> detectRequestBodyType(List<ParameterResolver<?>> parameterResolvers) {
        return parameterResolvers.stream().filter(parameterResolver -> parameterResolver.type == ParameterResolver.Type.BODY).map(p -> p.paramClass).findFirst();
    }

    private String generateActionSignature(List<ParameterResolver<?>> parameterResolvers) {
        this.checkOrder(parameterResolvers);
        if (this.path.replaceAll(" ", "").contains("{}")) {
            throw new IllegalArgumentException("Empty path parameter name for " + (Object)((Object)this.method) + " " + this.path);
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = this.pattern.matcher(this.path);
        boolean first = true;
        for (ParameterResolver<?> resolver : parameterResolvers) {
            if (resolver.type != ParameterResolver.Type.PATH) continue;
            matcher.find();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(resolver.paramClass.getSimpleName()).append(" ").append(matcher.group(1));
        }
        return result.toString();
    }

    private void checkOrder(List<ParameterResolver<?>> parameterResolvers) {
        boolean firstNonPathResolver = false;
        for (ParameterResolver<?> resolver : parameterResolvers) {
            if (resolver.type != ParameterResolver.Type.PATH) {
                firstNonPathResolver = true;
            }
            if (!firstNonPathResolver || resolver.type != ParameterResolver.Type.PATH) continue;
            throw new IllegalArgumentException("Path parameters are unsorted");
        }
    }

    protected Mapper mapperFrom(Class<? extends Mapper> mapperClass) {
        try {
            return mapperClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate mapper class: " + mapperClass.getName());
        }
    }
}

