/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.http.resource;

import io.vlingo.actors.Logger;
import io.vlingo.common.Completes;
import io.vlingo.http.Header;
import io.vlingo.http.Method;
import io.vlingo.http.Request;
import io.vlingo.http.Response;
import io.vlingo.http.resource.Action;
import io.vlingo.http.resource.ErrorHandler;
import io.vlingo.http.resource.Mapper;
import io.vlingo.http.resource.MediaTypeMapper;
import io.vlingo.http.resource.ObjectResponse;
import io.vlingo.http.resource.ParameterResolver;
import io.vlingo.http.resource.RequestExecutor;
import io.vlingo.http.resource.RequestHandler;
import io.vlingo.http.resource.RequestHandler1;
import io.vlingo.http.resource.RequestObjectExecutor;
import java.util.Collections;
import java.util.function.Supplier;

public class RequestHandler0
extends RequestHandler {
    private ParamExecutor0 executor;

    RequestHandler0(Method method, String path) {
        super(method, path, Collections.emptyList());
    }

    public RequestHandler0 handle(Handler0 handler) {
        this.executor = (request, mediaTypeMapper1, errorHandler1, logger) -> RequestExecutor.executeRequest(() -> handler.execute(), errorHandler1, logger);
        return this;
    }

    public <O> RequestHandler0 handle(ObjectHandler0<O> handler) {
        this.executor = (request, mediaTypeMapper1, errorHandler1, logger) -> RequestObjectExecutor.executeRequest(request, mediaTypeMapper1, () -> handler.execute(), errorHandler1, logger);
        return this;
    }

    public RequestHandler0 onError(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public RequestHandler0 mapper(MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
        return this;
    }

    Completes<Response> execute(Request request, Logger logger) {
        Supplier<Completes> exec = () -> this.executor.execute(request, this.mediaTypeMapper, this.errorHandler, logger);
        return this.runParamExecutor(this.executor, () -> RequestExecutor.executeRequest(exec, this.errorHandler, logger));
    }

    @Override
    protected Completes<Response> execute(Request request, Action.MappedParameters mappedParameters, Logger logger) {
        Completes<Response> response = this.execute(request, logger);
        return response;
    }

    public <T> RequestHandler1<T> param(Class<T> paramClass) {
        return new RequestHandler1<T>(this.method, this.path, ParameterResolver.path(0, paramClass), this.errorHandler, this.mediaTypeMapper);
    }

    public <T> RequestHandler1<T> body(Class<T> paramClass) {
        return new RequestHandler1<T>(this.method, this.path, ParameterResolver.body(paramClass, this.mediaTypeMapper), this.errorHandler, this.mediaTypeMapper);
    }

    @Deprecated
    public <T> RequestHandler1<T> body(Class<T> paramClass, Class<? extends Mapper> mapperClass) {
        return this.body(paramClass, this.mapperFrom(mapperClass));
    }

    @Deprecated
    public <T> RequestHandler1<T> body(Class<T> paramClass, Mapper mapper) {
        return new RequestHandler1<T>(this.method, this.path, ParameterResolver.body(paramClass, mapper), this.errorHandler, this.mediaTypeMapper);
    }

    public <T> RequestHandler1<T> body(Class<T> paramClass, MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
        return new RequestHandler1<T>(this.method, this.path, ParameterResolver.body(paramClass, mediaTypeMapper), this.errorHandler, mediaTypeMapper);
    }

    public RequestHandler1<String> query(String name) {
        return this.query(name, String.class);
    }

    public <T> RequestHandler1<T> query(String name, Class<T> type) {
        return this.query(name, type, null);
    }

    public <T> RequestHandler1<T> query(String name, Class<T> type, T defaultValue) {
        return new RequestHandler1<T>(this.method, this.path, ParameterResolver.query(name, type, defaultValue), this.errorHandler, this.mediaTypeMapper);
    }

    public RequestHandler1<Header> header(String name) {
        return new RequestHandler1<Header>(this.method, this.path, ParameterResolver.header(name), this.errorHandler, this.mediaTypeMapper);
    }

    @FunctionalInterface
    static interface ParamExecutor0 {
        public Completes<Response> execute(Request var1, MediaTypeMapper var2, ErrorHandler var3, Logger var4);
    }

    @FunctionalInterface
    public static interface ObjectHandler0<O> {
        public Completes<ObjectResponse<O>> execute();
    }

    @FunctionalInterface
    public static interface Handler0 {
        public Completes<Response> execute();
    }
}

